
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/latency/mojo/latency_info.mojom
//

package com.vccorp.ui.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class LatencyComponentType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT = 0;
    public static final int LATENCY_BEGIN_SCROLL_LISTENER_UPDATE_MAIN_COMPONENT = 1; // INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_RENDERER_MAIN_COMPONENT = 2; // LATENCY_BEGIN_SCROLL_LISTENER_UPDATE_MAIN_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_RENDERER_INVALIDATE_COMPONENT = 3; // LATENCY_BEGIN_FRAME_RENDERER_MAIN_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_RENDERER_COMPOSITOR_COMPONENT = 4; // LATENCY_BEGIN_FRAME_RENDERER_INVALIDATE_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_UI_MAIN_COMPONENT = 5; // LATENCY_BEGIN_FRAME_RENDERER_COMPOSITOR_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_UI_COMPOSITOR_COMPONENT = 6; // LATENCY_BEGIN_FRAME_UI_MAIN_COMPONENT + 1
    public static final int LATENCY_BEGIN_FRAME_DISPLAY_COMPOSITOR_COMPONENT = 7; // LATENCY_BEGIN_FRAME_UI_COMPOSITOR_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_SCROLL_UPDATE_ORIGINAL_COMPONENT = 8; // LATENCY_BEGIN_FRAME_DISPLAY_COMPOSITOR_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_FIRST_SCROLL_UPDATE_ORIGINAL_COMPONENT = 9; // INPUT_EVENT_LATENCY_SCROLL_UPDATE_ORIGINAL_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT = 10; // INPUT_EVENT_LATENCY_FIRST_SCROLL_UPDATE_ORIGINAL_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_UI_COMPONENT = 11; // INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_RENDERER_MAIN_COMPONENT = 12; // INPUT_EVENT_LATENCY_UI_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_MAIN_COMPONENT = 13; // INPUT_EVENT_LATENCY_RENDERER_MAIN_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_IMPL_COMPONENT = 14; // INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_MAIN_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_FORWARD_SCROLL_UPDATE_TO_MAIN_COMPONENT = 15; // INPUT_EVENT_LATENCY_RENDERING_SCHEDULED_IMPL_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_SCROLL_UPDATE_LAST_EVENT_COMPONENT = 16; // INPUT_EVENT_LATENCY_FORWARD_SCROLL_UPDATE_TO_MAIN_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_ACK_RWH_COMPONENT = 17; // INPUT_EVENT_LATENCY_SCROLL_UPDATE_LAST_EVENT_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_RENDERER_SWAP_COMPONENT = 18; // INPUT_EVENT_LATENCY_ACK_RWH_COMPONENT + 1
    public static final int DISPLAY_COMPOSITOR_RECEIVED_FRAME_COMPONENT = 19; // INPUT_EVENT_LATENCY_RENDERER_SWAP_COMPONENT + 1
    public static final int INPUT_EVENT_GPU_SWAP_BUFFER_COMPONENT = 20; // DISPLAY_COMPOSITOR_RECEIVED_FRAME_COMPONENT + 1
    public static final int INPUT_EVENT_LATENCY_FRAME_SWAP_COMPONENT = 21; // INPUT_EVENT_GPU_SWAP_BUFFER_COMPONENT + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 21;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private LatencyComponentType() {}
}