
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_request.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PaymentRequest_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PaymentRequest, PaymentRequest.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PaymentRequest, PaymentRequest.Proxy>() {

        @Override
        public String getName() {
            return "payments.mojom.PaymentRequest";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PaymentRequest impl) {
            return new Stub(core, impl);
        }

        @Override
        public PaymentRequest[] buildArray(int size) {
          return new PaymentRequest[size];
        }
    };


    private static final int INIT_ORDINAL = 0;

    private static final int SHOW_ORDINAL = 1;

    private static final int UPDATE_WITH_ORDINAL = 2;

    private static final int NO_UPDATED_PAYMENT_DETAILS_ORDINAL = 3;

    private static final int ABORT_ORDINAL = 4;

    private static final int COMPLETE_ORDINAL = 5;

    private static final int RETRY_ORDINAL = 6;

    private static final int CAN_MAKE_PAYMENT_ORDINAL = 7;

    private static final int HAS_ENROLLED_INSTRUMENT_ORDINAL = 8;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PaymentRequest.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void init(
PaymentRequestClient client, PaymentMethodData[] methodData, PaymentDetails details, PaymentOptions options) {

            PaymentRequestInitParams _message = new PaymentRequestInitParams();

            _message.client = client;

            _message.methodData = methodData;

            _message.details = details;

            _message.options = options;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INIT_ORDINAL)));

        }


        @Override
        public void show(
boolean isUserGesture, boolean waitForUpdatedDetails) {

            PaymentRequestShowParams _message = new PaymentRequestShowParams();

            _message.isUserGesture = isUserGesture;

            _message.waitForUpdatedDetails = waitForUpdatedDetails;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SHOW_ORDINAL)));

        }


        @Override
        public void updateWith(
PaymentDetails details) {

            PaymentRequestUpdateWithParams _message = new PaymentRequestUpdateWithParams();

            _message.details = details;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_WITH_ORDINAL)));

        }


        @Override
        public void noUpdatedPaymentDetails(
) {

            PaymentRequestNoUpdatedPaymentDetailsParams _message = new PaymentRequestNoUpdatedPaymentDetailsParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(NO_UPDATED_PAYMENT_DETAILS_ORDINAL)));

        }


        @Override
        public void abort(
) {

            PaymentRequestAbortParams _message = new PaymentRequestAbortParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ABORT_ORDINAL)));

        }


        @Override
        public void complete(
int result) {

            PaymentRequestCompleteParams _message = new PaymentRequestCompleteParams();

            _message.result = result;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(COMPLETE_ORDINAL)));

        }


        @Override
        public void retry(
PaymentValidationErrors errors) {

            PaymentRequestRetryParams _message = new PaymentRequestRetryParams();

            _message.errors = errors;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RETRY_ORDINAL)));

        }


        @Override
        public void canMakePayment(
boolean legacyMode) {

            PaymentRequestCanMakePaymentParams _message = new PaymentRequestCanMakePaymentParams();

            _message.legacyMode = legacyMode;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CAN_MAKE_PAYMENT_ORDINAL)));

        }


        @Override
        public void hasEnrolledInstrument(
boolean perMethodQuota) {

            PaymentRequestHasEnrolledInstrumentParams _message = new PaymentRequestHasEnrolledInstrumentParams();

            _message.perMethodQuota = perMethodQuota;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(HAS_ENROLLED_INSTRUMENT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PaymentRequest> {

        Stub(com.vccorp.mojo.system.Core core, PaymentRequest impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PaymentRequest_Internal.MANAGER, messageWithHeader);





                    case INIT_ORDINAL: {

                        PaymentRequestInitParams data =
                                PaymentRequestInitParams.deserialize(messageWithHeader.getPayload());

                        getImpl().init(data.client, data.methodData, data.details, data.options);
                        return true;
                    }





                    case SHOW_ORDINAL: {

                        PaymentRequestShowParams data =
                                PaymentRequestShowParams.deserialize(messageWithHeader.getPayload());

                        getImpl().show(data.isUserGesture, data.waitForUpdatedDetails);
                        return true;
                    }





                    case UPDATE_WITH_ORDINAL: {

                        PaymentRequestUpdateWithParams data =
                                PaymentRequestUpdateWithParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateWith(data.details);
                        return true;
                    }





                    case NO_UPDATED_PAYMENT_DETAILS_ORDINAL: {

                        PaymentRequestNoUpdatedPaymentDetailsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().noUpdatedPaymentDetails();
                        return true;
                    }





                    case ABORT_ORDINAL: {

                        PaymentRequestAbortParams.deserialize(messageWithHeader.getPayload());

                        getImpl().abort();
                        return true;
                    }





                    case COMPLETE_ORDINAL: {

                        PaymentRequestCompleteParams data =
                                PaymentRequestCompleteParams.deserialize(messageWithHeader.getPayload());

                        getImpl().complete(data.result);
                        return true;
                    }





                    case RETRY_ORDINAL: {

                        PaymentRequestRetryParams data =
                                PaymentRequestRetryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().retry(data.errors);
                        return true;
                    }





                    case CAN_MAKE_PAYMENT_ORDINAL: {

                        PaymentRequestCanMakePaymentParams data =
                                PaymentRequestCanMakePaymentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().canMakePayment(data.legacyMode);
                        return true;
                    }





                    case HAS_ENROLLED_INSTRUMENT_ORDINAL: {

                        PaymentRequestHasEnrolledInstrumentParams data =
                                PaymentRequestHasEnrolledInstrumentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().hasEnrolledInstrument(data.perMethodQuota);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PaymentRequest_Internal.MANAGER, messageWithHeader, receiver);




















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PaymentRequestInitParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentRequestClient client;
        public PaymentMethodData[] methodData;
        public PaymentDetails details;
        public PaymentOptions options;

        private PaymentRequestInitParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestInitParams() {
            this(0);
        }

        public static PaymentRequestInitParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestInitParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestInitParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestInitParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestInitParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, PaymentRequestClient.MANAGER);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.methodData = new PaymentMethodData[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.methodData[i1] = PaymentMethodData.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.details = PaymentDetails.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.options = PaymentOptions.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, PaymentRequestClient.MANAGER);
            
            if (this.methodData == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.methodData.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.methodData.length; ++i0) {
                    
                    encoder1.encode(this.methodData[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.details, 24, false);
            
            encoder0.encode(this.options, 32, false);
        }
    }



    
    static final class PaymentRequestShowParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean isUserGesture;
        public boolean waitForUpdatedDetails;

        private PaymentRequestShowParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestShowParams() {
            this(0);
        }

        public static PaymentRequestShowParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestShowParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestShowParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestShowParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestShowParams(elementsOrVersion);
                    {
                        
                    result.isUserGesture = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.waitForUpdatedDetails = decoder0.readBoolean(8, 1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.isUserGesture, 8, 0);
            
            encoder0.encode(this.waitForUpdatedDetails, 8, 1);
        }
    }



    
    static final class PaymentRequestUpdateWithParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentDetails details;

        private PaymentRequestUpdateWithParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestUpdateWithParams() {
            this(0);
        }

        public static PaymentRequestUpdateWithParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestUpdateWithParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestUpdateWithParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestUpdateWithParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestUpdateWithParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.details = PaymentDetails.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.details, 8, false);
        }
    }



    
    static final class PaymentRequestNoUpdatedPaymentDetailsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentRequestNoUpdatedPaymentDetailsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestNoUpdatedPaymentDetailsParams() {
            this(0);
        }

        public static PaymentRequestNoUpdatedPaymentDetailsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestNoUpdatedPaymentDetailsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestNoUpdatedPaymentDetailsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestNoUpdatedPaymentDetailsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestNoUpdatedPaymentDetailsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PaymentRequestAbortParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private PaymentRequestAbortParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestAbortParams() {
            this(0);
        }

        public static PaymentRequestAbortParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestAbortParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestAbortParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestAbortParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestAbortParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class PaymentRequestCompleteParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private PaymentRequestCompleteParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestCompleteParams() {
            this(0);
        }

        public static PaymentRequestCompleteParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestCompleteParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestCompleteParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestCompleteParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestCompleteParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        PaymentComplete.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }



    
    static final class PaymentRequestRetryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PaymentValidationErrors errors;

        private PaymentRequestRetryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestRetryParams() {
            this(0);
        }

        public static PaymentRequestRetryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestRetryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestRetryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestRetryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestRetryParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.errors = PaymentValidationErrors.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.errors, 8, false);
        }
    }



    
    static final class PaymentRequestCanMakePaymentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean legacyMode;

        private PaymentRequestCanMakePaymentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestCanMakePaymentParams() {
            this(0);
        }

        public static PaymentRequestCanMakePaymentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestCanMakePaymentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestCanMakePaymentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestCanMakePaymentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestCanMakePaymentParams(elementsOrVersion);
                    {
                        
                    result.legacyMode = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.legacyMode, 8, 0);
        }
    }



    
    static final class PaymentRequestHasEnrolledInstrumentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean perMethodQuota;

        private PaymentRequestHasEnrolledInstrumentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PaymentRequestHasEnrolledInstrumentParams() {
            this(0);
        }

        public static PaymentRequestHasEnrolledInstrumentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PaymentRequestHasEnrolledInstrumentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PaymentRequestHasEnrolledInstrumentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PaymentRequestHasEnrolledInstrumentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PaymentRequestHasEnrolledInstrumentParams(elementsOrVersion);
                    {
                        
                    result.perMethodQuota = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.perMethodQuota, 8, 0);
        }
    }



}
