
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/payments/payment_request.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PaymentMethodData extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(88, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String supportedMethod;
    public String stringifiedData;
    public int environment;
    public String merchantName;
    public String merchantId;
    public int[] allowedCardNetworks;
    public int tokenizationType;
    public AndroidPayTokenizationParameter[] parameters;
    public int minGooglePlayServicesVersion;
    public int apiVersion;
    public int[] supportedNetworks;
    public int[] supportedTypes;

    private PaymentMethodData(int version) {
        super(STRUCT_SIZE, version);
    }

    public PaymentMethodData() {
        this(0);
    }

    public static PaymentMethodData deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static PaymentMethodData deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static PaymentMethodData decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        PaymentMethodData result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new PaymentMethodData(elementsOrVersion);
                {
                    
                result.supportedMethod = decoder0.readString(8, false);
                }
                {
                    
                result.stringifiedData = decoder0.readString(16, false);
                }
                {
                    
                result.environment = decoder0.readInt(24);
                    AndroidPayEnvironment.validate(result.environment);
                }
                {
                    
                result.tokenizationType = decoder0.readInt(28);
                    AndroidPayTokenization.validate(result.tokenizationType);
                }
                {
                    
                result.merchantName = decoder0.readString(32, true);
                }
                {
                    
                result.merchantId = decoder0.readString(40, true);
                }
                {
                    
                result.allowedCardNetworks = decoder0.readInts(48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.allowedCardNetworks.length; ++i0) {
                        AndroidPayCardNetwork.validate(result.allowedCardNetworks[i0]);
                    }
                }
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.parameters = new AndroidPayTokenizationParameter[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.parameters[i1] = AndroidPayTokenizationParameter.decode(decoder2);
                    }
                }
                }
                {
                    
                result.minGooglePlayServicesVersion = decoder0.readInt(64);
                }
                {
                    
                result.apiVersion = decoder0.readInt(68);
                }
                {
                    
                result.supportedNetworks = decoder0.readInts(72, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.supportedNetworks.length; ++i0) {
                        BasicCardNetwork.validate(result.supportedNetworks[i0]);
                    }
                }
                }
                {
                    
                result.supportedTypes = decoder0.readInts(80, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.supportedTypes.length; ++i0) {
                        BasicCardType.validate(result.supportedTypes[i0]);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.supportedMethod, 8, false);
        
        encoder0.encode(this.stringifiedData, 16, false);
        
        encoder0.encode(this.environment, 24);
        
        encoder0.encode(this.tokenizationType, 28);
        
        encoder0.encode(this.merchantName, 32, true);
        
        encoder0.encode(this.merchantId, 40, true);
        
        encoder0.encode(this.allowedCardNetworks, 48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        if (this.parameters == null) {
            encoder0.encodeNullPointer(56, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.parameters.length, 56, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.parameters.length; ++i0) {
                
                encoder1.encode(this.parameters[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.minGooglePlayServicesVersion, 64);
        
        encoder0.encode(this.apiVersion, 68);
        
        encoder0.encode(this.supportedNetworks, 72, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.supportedTypes, 80, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}