
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     components/payments/mojom/payment_request_data.mojom
//

package com.vccorp.payments.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PaymentAddress extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(88, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String country;
    public String[] addressLine;
    public String region;
    public String city;
    public String dependentLocality;
    public String postalCode;
    public String sortingCode;
    public String organization;
    public String recipient;
    public String phone;

    private PaymentAddress(int version) {
        super(STRUCT_SIZE, version);
    }

    public PaymentAddress() {
        this(0);
    }

    public static PaymentAddress deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static PaymentAddress deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static PaymentAddress decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        PaymentAddress result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new PaymentAddress(elementsOrVersion);
                {
                    
                result.country = decoder0.readString(8, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.addressLine = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        result.addressLine[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
                }
                {
                    
                result.region = decoder0.readString(24, false);
                }
                {
                    
                result.city = decoder0.readString(32, false);
                }
                {
                    
                result.dependentLocality = decoder0.readString(40, false);
                }
                {
                    
                result.postalCode = decoder0.readString(48, false);
                }
                {
                    
                result.sortingCode = decoder0.readString(56, false);
                }
                {
                    
                result.organization = decoder0.readString(64, false);
                }
                {
                    
                result.recipient = decoder0.readString(72, false);
                }
                {
                    
                result.phone = decoder0.readString(80, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.country, 8, false);
        
        if (this.addressLine == null) {
            encoder0.encodeNullPointer(16, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.addressLine.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.addressLine.length; ++i0) {
                
                encoder1.encode(this.addressLine[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.region, 24, false);
        
        encoder0.encode(this.city, 32, false);
        
        encoder0.encode(this.dependentLocality, 40, false);
        
        encoder0.encode(this.postalCode, 48, false);
        
        encoder0.encode(this.sortingCode, 56, false);
        
        encoder0.encode(this.organization, 64, false);
        
        encoder0.encode(this.recipient, 72, false);
        
        encoder0.encode(this.phone, 80, false);
    }
}