
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/tcp_socket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class TcpServerSocket_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<TcpServerSocket, TcpServerSocket.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.TCPServerSocket";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, TcpServerSocket impl) {
            return new Stub(core, impl);
        }

        @Override
        public TcpServerSocket[] buildArray(int size) {
          return new TcpServerSocket[size];
        }
    };


    private static final int ACCEPT_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements TcpServerSocket.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void accept(
SocketObserver observer, 
AcceptResponse callback) {

            TcpServerSocketAcceptParams _message = new TcpServerSocketAcceptParams();

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ACCEPT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpServerSocketAcceptResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<TcpServerSocket> {

        Stub(com.vccorp.mojo.system.Core core, TcpServerSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TcpServerSocket_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TcpServerSocket_Internal.MANAGER, messageWithHeader, receiver);







                    case ACCEPT_ORDINAL: {

                        TcpServerSocketAcceptParams data =
                                TcpServerSocketAcceptParams.deserialize(messageWithHeader.getPayload());

                        getImpl().accept(data.observer, new TcpServerSocketAcceptResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class TcpServerSocketAcceptParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SocketObserver observer;

        private TcpServerSocketAcceptParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public TcpServerSocketAcceptParams() {
            this(0);
        }

        public static TcpServerSocketAcceptParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpServerSocketAcceptParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpServerSocketAcceptParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpServerSocketAcceptParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpServerSocketAcceptParams(elementsOrVersion);
                    {
                        
                    result.observer = decoder0.readServiceInterface(8, true, SocketObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.observer, 8, true, SocketObserver.MANAGER);
        }
    }



    
    static final class TcpServerSocketAcceptResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;
        public IpEndPoint remoteAddr;
        public TcpConnectedSocket connectedSocket;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle sendStream;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle receiveStream;

        private TcpServerSocketAcceptResponseParams(int version) {
            super(STRUCT_SIZE, version);
            this.sendStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.receiveStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public TcpServerSocketAcceptResponseParams() {
            this(0);
        }

        public static TcpServerSocketAcceptResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static TcpServerSocketAcceptResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static TcpServerSocketAcceptResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            TcpServerSocketAcceptResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new TcpServerSocketAcceptResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }
                    {
                        
                    result.sendStream = decoder0.readConsumerHandle(12, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.remoteAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.connectedSocket = decoder0.readServiceInterface(24, true, TcpConnectedSocket.MANAGER);
                    }
                    {
                        
                    result.receiveStream = decoder0.readProducerHandle(32, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
            
            encoder0.encode(this.sendStream, 12, true);
            
            encoder0.encode(this.remoteAddr, 16, true);
            
            encoder0.encode(this.connectedSocket, 24, true, TcpConnectedSocket.MANAGER);
            
            encoder0.encode(this.receiveStream, 32, true);
        }
    }

    static class TcpServerSocketAcceptResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final TcpServerSocket.AcceptResponse mCallback;

        TcpServerSocketAcceptResponseParamsForwardToCallback(TcpServerSocket.AcceptResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ACCEPT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                TcpServerSocketAcceptResponseParams response = TcpServerSocketAcceptResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError, response.remoteAddr, response.connectedSocket, response.sendStream, response.receiveStream);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpServerSocketAcceptResponseParamsProxyToResponder implements TcpServerSocket.AcceptResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpServerSocketAcceptResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError, IpEndPoint remoteAddr, TcpConnectedSocket connectedSocket, com.vccorp.mojo.system.DataPipe.ConsumerHandle sendStream, com.vccorp.mojo.system.DataPipe.ProducerHandle receiveStream) {
            TcpServerSocketAcceptResponseParams _response = new TcpServerSocketAcceptResponseParams();

            _response.netError = netError;

            _response.remoteAddr = remoteAddr;

            _response.connectedSocket = connectedSocket;

            _response.sendStream = sendStream;

            _response.receiveStream = receiveStream;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ACCEPT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
