
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service_test.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ResolverType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int RESOLVER_TYPE_FAIL = 0;
    public static final int RESOLVER_TYPE_SYSTEM = 1; // RESOLVER_TYPE_FAIL + 1
    public static final int RESOLVER_TYPE_IP_LITERAL = 2; // RESOLVER_TYPE_SYSTEM + 1
    public static final int RESOLVER_TYPE_DIRECT_LOOKUP = 3; // RESOLVER_TYPE_IP_LITERAL + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 3;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ResolverType() {}
}