
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/host_resolver.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ResolveHostParameters extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class Source {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int ANY = 0;
        public static final int SYSTEM = 1; // ANY + 1
        public static final int DNS = 2; // SYSTEM + 1
        public static final int MULTICAST_DNS = 3; // DNS + 1
        public static final int LOCAL_ONLY = 4; // MULTICAST_DNS + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 4;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private Source() {}
    }
    public int dnsQueryType;
    public int initialPriority;
    public int source;
    public boolean allowCachedResponse;
    public com.vccorp.mojo.bindings.InterfaceRequest<ResolveHostHandle> controlHandle;
    public boolean includeCanonicalName;
    public boolean loopbackOnly;
    public boolean isSpeculative;

    private ResolveHostParameters(int version) {
        super(STRUCT_SIZE, version);
        this.dnsQueryType = (int) DnsQueryType.UNSPECIFIED;
        this.initialPriority = (int) RequestPriority.LOWEST;
        this.source = (int) ResolveHostParameters.Source.ANY;
        this.allowCachedResponse = (boolean) true;
        this.includeCanonicalName = (boolean) false;
        this.loopbackOnly = (boolean) false;
        this.isSpeculative = (boolean) false;
    }

    public ResolveHostParameters() {
        this(0);
    }

    public static ResolveHostParameters deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ResolveHostParameters deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ResolveHostParameters decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ResolveHostParameters result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ResolveHostParameters(elementsOrVersion);
                {
                    
                result.dnsQueryType = decoder0.readInt(8);
                    DnsQueryType.validate(result.dnsQueryType);
                }
                {
                    
                result.initialPriority = decoder0.readInt(12);
                    RequestPriority.validate(result.initialPriority);
                }
                {
                    
                result.source = decoder0.readInt(16);
                    ResolveHostParameters.Source.validate(result.source);
                }
                {
                    
                result.allowCachedResponse = decoder0.readBoolean(20, 0);
                }
                {
                    
                result.includeCanonicalName = decoder0.readBoolean(20, 1);
                }
                {
                    
                result.loopbackOnly = decoder0.readBoolean(20, 2);
                }
                {
                    
                result.isSpeculative = decoder0.readBoolean(20, 3);
                }
                {
                    
                result.controlHandle = decoder0.readInterfaceRequest(24, true);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.dnsQueryType, 8);
        
        encoder0.encode(this.initialPriority, 12);
        
        encoder0.encode(this.source, 16);
        
        encoder0.encode(this.allowCachedResponse, 20, 0);
        
        encoder0.encode(this.includeCanonicalName, 20, 1);
        
        encoder0.encode(this.loopbackOnly, 20, 2);
        
        encoder0.encode(this.isSpeculative, 20, 3);
        
        encoder0.encode(this.controlHandle, 24, true);
    }
}