
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/proxy_resolving_socket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ProxyResolvingSocket_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ProxyResolvingSocket, ProxyResolvingSocket.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ProxyResolvingSocket, ProxyResolvingSocket.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.ProxyResolvingSocket";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ProxyResolvingSocket impl) {
            return new Stub(core, impl);
        }

        @Override
        public ProxyResolvingSocket[] buildArray(int size) {
          return new ProxyResolvingSocket[size];
        }
    };


    private static final int UPGRADE_TO_TLS_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ProxyResolvingSocket.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void upgradeToTls(
HostPortPair hostPortPair, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TlsClientSocket> request, SocketObserver observer,
UpgradeToTlsResponse callback) {

            ProxyResolvingSocketUpgradeToTlsParams _message = new ProxyResolvingSocketUpgradeToTlsParams();

            _message.hostPortPair = hostPortPair;

            _message.trafficAnnotation = trafficAnnotation;

            _message.request = request;

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPGRADE_TO_TLS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ProxyResolvingSocketUpgradeToTlsResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ProxyResolvingSocket> {

        Stub(com.vccorp.mojo.system.Core core, ProxyResolvingSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyResolvingSocket_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyResolvingSocket_Internal.MANAGER, messageWithHeader, receiver);







                    case UPGRADE_TO_TLS_ORDINAL: {

                        ProxyResolvingSocketUpgradeToTlsParams data =
                                ProxyResolvingSocketUpgradeToTlsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().upgradeToTls(data.hostPortPair, data.trafficAnnotation, data.request, data.observer, new ProxyResolvingSocketUpgradeToTlsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ProxyResolvingSocketUpgradeToTlsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HostPortPair hostPortPair;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<TlsClientSocket> request;
        public SocketObserver observer;

        private ProxyResolvingSocketUpgradeToTlsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ProxyResolvingSocketUpgradeToTlsParams() {
            this(0);
        }

        public static ProxyResolvingSocketUpgradeToTlsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolvingSocketUpgradeToTlsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolvingSocketUpgradeToTlsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolvingSocketUpgradeToTlsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolvingSocketUpgradeToTlsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.hostPortPair = HostPortPair.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }
                    {
                        
                    result.request = decoder0.readInterfaceRequest(24, false);
                    }
                    {
                        
                    result.observer = decoder0.readServiceInterface(28, true, SocketObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.hostPortPair, 8, false);
            
            encoder0.encode(this.trafficAnnotation, 16, false);
            
            encoder0.encode(this.request, 24, false);
            
            encoder0.encode(this.observer, 28, true, SocketObserver.MANAGER);
        }
    }



    
    static final class ProxyResolvingSocketUpgradeToTlsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int netError;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream;

        private ProxyResolvingSocketUpgradeToTlsResponseParams(int version) {
            super(STRUCT_SIZE, version);
            this.receiveStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.sendStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public ProxyResolvingSocketUpgradeToTlsResponseParams() {
            this(0);
        }

        public static ProxyResolvingSocketUpgradeToTlsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ProxyResolvingSocketUpgradeToTlsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ProxyResolvingSocketUpgradeToTlsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ProxyResolvingSocketUpgradeToTlsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ProxyResolvingSocketUpgradeToTlsResponseParams(elementsOrVersion);
                    {
                        
                    result.netError = decoder0.readInt(8);
                    }
                    {
                        
                    result.receiveStream = decoder0.readConsumerHandle(12, true);
                    }
                    {
                        
                    result.sendStream = decoder0.readProducerHandle(16, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.netError, 8);
            
            encoder0.encode(this.receiveStream, 12, true);
            
            encoder0.encode(this.sendStream, 16, true);
        }
    }

    static class ProxyResolvingSocketUpgradeToTlsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final ProxyResolvingSocket.UpgradeToTlsResponse mCallback;

        ProxyResolvingSocketUpgradeToTlsResponseParamsForwardToCallback(ProxyResolvingSocket.UpgradeToTlsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(UPGRADE_TO_TLS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                ProxyResolvingSocketUpgradeToTlsResponseParams response = ProxyResolvingSocketUpgradeToTlsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.netError, response.receiveStream, response.sendStream);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ProxyResolvingSocketUpgradeToTlsResponseParamsProxyToResponder implements ProxyResolvingSocket.UpgradeToTlsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ProxyResolvingSocketUpgradeToTlsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer netError, com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream, com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream) {
            ProxyResolvingSocketUpgradeToTlsResponseParams _response = new ProxyResolvingSocketUpgradeToTlsResponseParams();

            _response.netError = netError;

            _response.receiveStream = receiveStream;

            _response.sendStream = sendStream;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    UPGRADE_TO_TLS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
