
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/p2p_trusted.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class P2pTrustedSocketManagerClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<P2pTrustedSocketManagerClient, P2pTrustedSocketManagerClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<P2pTrustedSocketManagerClient, P2pTrustedSocketManagerClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.P2PTrustedSocketManagerClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, P2pTrustedSocketManagerClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public P2pTrustedSocketManagerClient[] buildArray(int size) {
          return new P2pTrustedSocketManagerClient[size];
        }
    };


    private static final int INVALID_SOCKET_PORT_RANGE_REQUESTED_ORDINAL = 0;

    private static final int DUMP_PACKET_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements P2pTrustedSocketManagerClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void invalidSocketPortRangeRequested(
) {

            P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams _message = new P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INVALID_SOCKET_PORT_RANGE_REQUESTED_ORDINAL)));

        }


        @Override
        public void dumpPacket(
byte[] packetHeader, long packetLength, boolean incoming) {

            P2pTrustedSocketManagerClientDumpPacketParams _message = new P2pTrustedSocketManagerClientDumpPacketParams();

            _message.packetHeader = packetHeader;

            _message.packetLength = packetLength;

            _message.incoming = incoming;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DUMP_PACKET_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<P2pTrustedSocketManagerClient> {

        Stub(com.vccorp.mojo.system.Core core, P2pTrustedSocketManagerClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                P2pTrustedSocketManagerClient_Internal.MANAGER, messageWithHeader);





                    case INVALID_SOCKET_PORT_RANGE_REQUESTED_ORDINAL: {

                        P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().invalidSocketPortRangeRequested();
                        return true;
                    }





                    case DUMP_PACKET_ORDINAL: {

                        P2pTrustedSocketManagerClientDumpPacketParams data =
                                P2pTrustedSocketManagerClientDumpPacketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dumpPacket(data.packetHeader, data.packetLength, data.incoming);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), P2pTrustedSocketManagerClient_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams() {
            this(0);
        }

        public static P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pTrustedSocketManagerClientInvalidSocketPortRangeRequestedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class P2pTrustedSocketManagerClientDumpPacketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public byte[] packetHeader;
        public long packetLength;
        public boolean incoming;

        private P2pTrustedSocketManagerClientDumpPacketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pTrustedSocketManagerClientDumpPacketParams() {
            this(0);
        }

        public static P2pTrustedSocketManagerClientDumpPacketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pTrustedSocketManagerClientDumpPacketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pTrustedSocketManagerClientDumpPacketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pTrustedSocketManagerClientDumpPacketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pTrustedSocketManagerClientDumpPacketParams(elementsOrVersion);
                    {
                        
                    result.packetHeader = decoder0.readBytes(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.packetLength = decoder0.readLong(16);
                    }
                    {
                        
                    result.incoming = decoder0.readBoolean(24, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.packetHeader, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.packetLength, 16);
            
            encoder0.encode(this.incoming, 24, 0);
        }
    }



}
