
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/p2p.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class P2pSocketManager_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<P2pSocketManager, P2pSocketManager.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<P2pSocketManager, P2pSocketManager.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.P2PSocketManager";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, P2pSocketManager impl) {
            return new Stub(core, impl);
        }

        @Override
        public P2pSocketManager[] buildArray(int size) {
          return new P2pSocketManager[size];
        }
    };


    private static final int START_NETWORK_NOTIFICATIONS_ORDINAL = 0;

    private static final int GET_HOST_ADDRESS_ORDINAL = 1;

    private static final int CREATE_SOCKET_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements P2pSocketManager.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void startNetworkNotifications(
P2pNetworkNotificationClient client) {

            P2pSocketManagerStartNetworkNotificationsParams _message = new P2pSocketManagerStartNetworkNotificationsParams();

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_NETWORK_NOTIFICATIONS_ORDINAL)));

        }


        @Override
        public void getHostAddress(
String hostName, boolean enableMdns, 
GetHostAddressResponse callback) {

            P2pSocketManagerGetHostAddressParams _message = new P2pSocketManagerGetHostAddressParams();

            _message.hostName = hostName;

            _message.enableMdns = enableMdns;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_HOST_ADDRESS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new P2pSocketManagerGetHostAddressResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createSocket(
int type, IpEndPoint localAddress, P2pPortRange portRange, P2pHostAndIpEndPoint remoteAddress, P2pSocketClient client, com.vccorp.mojo.bindings.InterfaceRequest<P2pSocket> socket) {

            P2pSocketManagerCreateSocketParams _message = new P2pSocketManagerCreateSocketParams();

            _message.type = type;

            _message.localAddress = localAddress;

            _message.portRange = portRange;

            _message.remoteAddress = remoteAddress;

            _message.client = client;

            _message.socket = socket;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_SOCKET_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<P2pSocketManager> {

        Stub(com.vccorp.mojo.system.Core core, P2pSocketManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                P2pSocketManager_Internal.MANAGER, messageWithHeader);





                    case START_NETWORK_NOTIFICATIONS_ORDINAL: {

                        P2pSocketManagerStartNetworkNotificationsParams data =
                                P2pSocketManagerStartNetworkNotificationsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startNetworkNotifications(data.client);
                        return true;
                    }







                    case CREATE_SOCKET_ORDINAL: {

                        P2pSocketManagerCreateSocketParams data =
                                P2pSocketManagerCreateSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createSocket(data.type, data.localAddress, data.portRange, data.remoteAddress, data.client, data.socket);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), P2pSocketManager_Internal.MANAGER, messageWithHeader, receiver);









                    case GET_HOST_ADDRESS_ORDINAL: {

                        P2pSocketManagerGetHostAddressParams data =
                                P2pSocketManagerGetHostAddressParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getHostAddress(data.hostName, data.enableMdns, new P2pSocketManagerGetHostAddressResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class P2pSocketManagerStartNetworkNotificationsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public P2pNetworkNotificationClient client;

        private P2pSocketManagerStartNetworkNotificationsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketManagerStartNetworkNotificationsParams() {
            this(0);
        }

        public static P2pSocketManagerStartNetworkNotificationsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketManagerStartNetworkNotificationsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketManagerStartNetworkNotificationsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketManagerStartNetworkNotificationsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketManagerStartNetworkNotificationsParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, P2pNetworkNotificationClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, P2pNetworkNotificationClient.MANAGER);
        }
    }



    
    static final class P2pSocketManagerGetHostAddressParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String hostName;
        public boolean enableMdns;

        private P2pSocketManagerGetHostAddressParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketManagerGetHostAddressParams() {
            this(0);
        }

        public static P2pSocketManagerGetHostAddressParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketManagerGetHostAddressParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketManagerGetHostAddressParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketManagerGetHostAddressParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketManagerGetHostAddressParams(elementsOrVersion);
                    {
                        
                    result.hostName = decoder0.readString(8, false);
                    }
                    {
                        
                    result.enableMdns = decoder0.readBoolean(16, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.hostName, 8, false);
            
            encoder0.encode(this.enableMdns, 16, 0);
        }
    }



    
    static final class P2pSocketManagerGetHostAddressResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpAddress[] addresses;

        private P2pSocketManagerGetHostAddressResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketManagerGetHostAddressResponseParams() {
            this(0);
        }

        public static P2pSocketManagerGetHostAddressResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketManagerGetHostAddressResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketManagerGetHostAddressResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketManagerGetHostAddressResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketManagerGetHostAddressResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.addresses = new IpAddress[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.addresses[i1] = IpAddress.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.addresses == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.addresses.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.addresses.length; ++i0) {
                    
                    encoder1.encode(this.addresses[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class P2pSocketManagerGetHostAddressResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final P2pSocketManager.GetHostAddressResponse mCallback;

        P2pSocketManagerGetHostAddressResponseParamsForwardToCallback(P2pSocketManager.GetHostAddressResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_HOST_ADDRESS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                P2pSocketManagerGetHostAddressResponseParams response = P2pSocketManagerGetHostAddressResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.addresses);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class P2pSocketManagerGetHostAddressResponseParamsProxyToResponder implements P2pSocketManager.GetHostAddressResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        P2pSocketManagerGetHostAddressResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(IpAddress[] addresses) {
            P2pSocketManagerGetHostAddressResponseParams _response = new P2pSocketManagerGetHostAddressResponseParams();

            _response.addresses = addresses;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_HOST_ADDRESS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class P2pSocketManagerCreateSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int type;
        public IpEndPoint localAddress;
        public P2pPortRange portRange;
        public P2pHostAndIpEndPoint remoteAddress;
        public P2pSocketClient client;
        public com.vccorp.mojo.bindings.InterfaceRequest<P2pSocket> socket;

        private P2pSocketManagerCreateSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketManagerCreateSocketParams() {
            this(0);
        }

        public static P2pSocketManagerCreateSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketManagerCreateSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketManagerCreateSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketManagerCreateSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketManagerCreateSocketParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readInt(8);
                        P2pSocketType.validate(result.type);
                    }
                    {
                        
                    result.socket = decoder0.readInterfaceRequest(12, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.localAddress = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.portRange = P2pPortRange.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.remoteAddress = P2pHostAndIpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(40, false, P2pSocketClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8);
            
            encoder0.encode(this.socket, 12, false);
            
            encoder0.encode(this.localAddress, 16, false);
            
            encoder0.encode(this.portRange, 24, false);
            
            encoder0.encode(this.remoteAddress, 32, false);
            
            encoder0.encode(this.client, 40, false, P2pSocketClient.MANAGER);
        }
    }



}
