
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkService, NetworkService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkService, NetworkService.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkService impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkService[] buildArray(int size) {
          return new NetworkService[size];
        }
    };


    private static final int SET_CLIENT_ORDINAL = 0;

    private static final int START_NET_LOG_ORDINAL = 1;

    private static final int SET_SSL_KEY_LOG_FILE_ORDINAL = 2;

    private static final int CREATE_NETWORK_CONTEXT_ORDINAL = 3;

    private static final int CONFIGURE_STUB_HOST_RESOLVER_ORDINAL = 4;

    private static final int DISABLE_QUIC_ORDINAL = 5;

    private static final int SET_UP_HTTP_AUTH_ORDINAL = 6;

    private static final int CONFIGURE_HTTP_AUTH_PREFS_ORDINAL = 7;

    private static final int SET_RAW_HEADERS_ACCESS_ORDINAL = 8;

    private static final int GET_NETWORK_CHANGE_MANAGER_ORDINAL = 9;

    private static final int GET_NETWORK_QUALITY_ESTIMATOR_MANAGER_ORDINAL = 10;

    private static final int GET_DNS_CONFIG_CHANGE_MANAGER_ORDINAL = 11;

    private static final int GET_TOTAL_NETWORK_USAGES_ORDINAL = 12;

    private static final int GET_NETWORK_LIST_ORDINAL = 13;

    private static final int UPDATE_SIGNED_TREE_HEAD_ORDINAL = 14;

    private static final int UPDATE_CRL_SET_ORDINAL = 15;

    private static final int ON_CERT_DB_CHANGED_ORDINAL = 16;

    private static final int ADD_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL = 17;

    private static final int REMOVE_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL = 18;

    private static final int ON_MEMORY_PRESSURE_ORDINAL = 19;

    private static final int ON_APPLICATION_STATE_CHANGE_ORDINAL = 20;

    private static final int SET_ENVIRONMENT_ORDINAL = 21;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setClient(
NetworkServiceClient client, NetworkServiceParams params) {

            NetworkServiceSetClientParams _message = new NetworkServiceSetClientParams();

            _message.client = client;

            _message.params = params;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CLIENT_ORDINAL)));

        }


        @Override
        public void startNetLog(
com.vccorp.mojo_base.mojom.File file, int captureMode, com.vccorp.mojo_base.mojom.DictionaryValue constants) {

            NetworkServiceStartNetLogParams _message = new NetworkServiceStartNetLogParams();

            _message.file = file;

            _message.captureMode = captureMode;

            _message.constants = constants;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_NET_LOG_ORDINAL)));

        }


        @Override
        public void setSslKeyLogFile(
com.vccorp.mojo_base.mojom.FilePath file) {

            NetworkServiceSetSslKeyLogFileParams _message = new NetworkServiceSetSslKeyLogFileParams();

            _message.file = file;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_SSL_KEY_LOG_FILE_ORDINAL)));

        }


        @Override
        public void createNetworkContext(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkContext> context, NetworkContextParams params) {

            NetworkServiceCreateNetworkContextParams _message = new NetworkServiceCreateNetworkContextParams();

            _message.context = context;

            _message.params = params;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_NETWORK_CONTEXT_ORDINAL)));

        }


        @Override
        public void configureStubHostResolver(
boolean stubResolverEnabled, DnsOverHttpsServer[] dnsOverHttpsServers) {

            NetworkServiceConfigureStubHostResolverParams _message = new NetworkServiceConfigureStubHostResolverParams();

            _message.stubResolverEnabled = stubResolverEnabled;

            _message.dnsOverHttpsServers = dnsOverHttpsServers;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CONFIGURE_STUB_HOST_RESOLVER_ORDINAL)));

        }


        @Override
        public void disableQuic(
) {

            NetworkServiceDisableQuicParams _message = new NetworkServiceDisableQuicParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DISABLE_QUIC_ORDINAL)));

        }


        @Override
        public void setUpHttpAuth(
HttpAuthStaticParams httpAuthStaticParams) {

            NetworkServiceSetUpHttpAuthParams _message = new NetworkServiceSetUpHttpAuthParams();

            _message.httpAuthStaticParams = httpAuthStaticParams;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_UP_HTTP_AUTH_ORDINAL)));

        }


        @Override
        public void configureHttpAuthPrefs(
HttpAuthDynamicParams httpAuthDynamicParams) {

            NetworkServiceConfigureHttpAuthPrefsParams _message = new NetworkServiceConfigureHttpAuthPrefsParams();

            _message.httpAuthDynamicParams = httpAuthDynamicParams;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CONFIGURE_HTTP_AUTH_PREFS_ORDINAL)));

        }


        @Override
        public void setRawHeadersAccess(
int processId, com.vccorp.url.mojom.Origin[] origins) {

            NetworkServiceSetRawHeadersAccessParams _message = new NetworkServiceSetRawHeadersAccessParams();

            _message.processId = processId;

            _message.origins = origins;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_RAW_HEADERS_ACCESS_ORDINAL)));

        }


        @Override
        public void getNetworkChangeManager(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkChangeManager> networkChangeManager) {

            NetworkServiceGetNetworkChangeManagerParams _message = new NetworkServiceGetNetworkChangeManagerParams();

            _message.networkChangeManager = networkChangeManager;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_NETWORK_CHANGE_MANAGER_ORDINAL)));

        }


        @Override
        public void getNetworkQualityEstimatorManager(
com.vccorp.mojo.bindings.InterfaceRequest<NetworkQualityEstimatorManager> networkQualityEstimatorManager) {

            NetworkServiceGetNetworkQualityEstimatorManagerParams _message = new NetworkServiceGetNetworkQualityEstimatorManagerParams();

            _message.networkQualityEstimatorManager = networkQualityEstimatorManager;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_NETWORK_QUALITY_ESTIMATOR_MANAGER_ORDINAL)));

        }


        @Override
        public void getDnsConfigChangeManager(
com.vccorp.mojo.bindings.InterfaceRequest<DnsConfigChangeManager> dnsConfigChangeManager) {

            NetworkServiceGetDnsConfigChangeManagerParams _message = new NetworkServiceGetDnsConfigChangeManagerParams();

            _message.dnsConfigChangeManager = dnsConfigChangeManager;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_DNS_CONFIG_CHANGE_MANAGER_ORDINAL)));

        }


        @Override
        public void getTotalNetworkUsages(

GetTotalNetworkUsagesResponse callback) {

            NetworkServiceGetTotalNetworkUsagesParams _message = new NetworkServiceGetTotalNetworkUsagesParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_TOTAL_NETWORK_USAGES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceGetTotalNetworkUsagesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getNetworkList(
int policy, 
GetNetworkListResponse callback) {

            NetworkServiceGetNetworkListParams _message = new NetworkServiceGetNetworkListParams();

            _message.policy = policy;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NETWORK_LIST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkServiceGetNetworkListResponseParamsForwardToCallback(callback));

        }


        @Override
        public void updateSignedTreeHead(
SignedTreeHead signedTreeHead) {

            NetworkServiceUpdateSignedTreeHeadParams _message = new NetworkServiceUpdateSignedTreeHeadParams();

            _message.signedTreeHead = signedTreeHead;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_SIGNED_TREE_HEAD_ORDINAL)));

        }


        @Override
        public void updateCrlSet(
com.vccorp.mojo_base.mojom.ReadOnlyBuffer crlSet) {

            NetworkServiceUpdateCrlSetParams _message = new NetworkServiceUpdateCrlSetParams();

            _message.crlSet = crlSet;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_CRL_SET_ORDINAL)));

        }


        @Override
        public void onCertDbChanged(
) {

            NetworkServiceOnCertDbChangedParams _message = new NetworkServiceOnCertDbChangedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_CERT_DB_CHANGED_ORDINAL)));

        }


        @Override
        public void addCorbExceptionForPlugin(
int processId) {

            NetworkServiceAddCorbExceptionForPluginParams _message = new NetworkServiceAddCorbExceptionForPluginParams();

            _message.processId = processId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL)));

        }


        @Override
        public void removeCorbExceptionForPlugin(
int processId) {

            NetworkServiceRemoveCorbExceptionForPluginParams _message = new NetworkServiceRemoveCorbExceptionForPluginParams();

            _message.processId = processId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REMOVE_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL)));

        }


        @Override
        public void onMemoryPressure(
int memoryPressureLevel) {

            NetworkServiceOnMemoryPressureParams _message = new NetworkServiceOnMemoryPressureParams();

            _message.memoryPressureLevel = memoryPressureLevel;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_MEMORY_PRESSURE_ORDINAL)));

        }


        @Override
        public void onApplicationStateChange(
int state) {

            NetworkServiceOnApplicationStateChangeParams _message = new NetworkServiceOnApplicationStateChangeParams();

            _message.state = state;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_APPLICATION_STATE_CHANGE_ORDINAL)));

        }


        @Override
        public void setEnvironment(
EnvironmentVariable[] environment) {

            NetworkServiceSetEnvironmentParams _message = new NetworkServiceSetEnvironmentParams();

            _message.environment = environment;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_ENVIRONMENT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkService> {

        Stub(com.vccorp.mojo.system.Core core, NetworkService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkService_Internal.MANAGER, messageWithHeader);





                    case SET_CLIENT_ORDINAL: {

                        NetworkServiceSetClientParams data =
                                NetworkServiceSetClientParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setClient(data.client, data.params);
                        return true;
                    }





                    case START_NET_LOG_ORDINAL: {

                        NetworkServiceStartNetLogParams data =
                                NetworkServiceStartNetLogParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startNetLog(data.file, data.captureMode, data.constants);
                        return true;
                    }





                    case SET_SSL_KEY_LOG_FILE_ORDINAL: {

                        NetworkServiceSetSslKeyLogFileParams data =
                                NetworkServiceSetSslKeyLogFileParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setSslKeyLogFile(data.file);
                        return true;
                    }





                    case CREATE_NETWORK_CONTEXT_ORDINAL: {

                        NetworkServiceCreateNetworkContextParams data =
                                NetworkServiceCreateNetworkContextParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createNetworkContext(data.context, data.params);
                        return true;
                    }





                    case CONFIGURE_STUB_HOST_RESOLVER_ORDINAL: {

                        NetworkServiceConfigureStubHostResolverParams data =
                                NetworkServiceConfigureStubHostResolverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().configureStubHostResolver(data.stubResolverEnabled, data.dnsOverHttpsServers);
                        return true;
                    }





                    case DISABLE_QUIC_ORDINAL: {

                        NetworkServiceDisableQuicParams.deserialize(messageWithHeader.getPayload());

                        getImpl().disableQuic();
                        return true;
                    }





                    case SET_UP_HTTP_AUTH_ORDINAL: {

                        NetworkServiceSetUpHttpAuthParams data =
                                NetworkServiceSetUpHttpAuthParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setUpHttpAuth(data.httpAuthStaticParams);
                        return true;
                    }





                    case CONFIGURE_HTTP_AUTH_PREFS_ORDINAL: {

                        NetworkServiceConfigureHttpAuthPrefsParams data =
                                NetworkServiceConfigureHttpAuthPrefsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().configureHttpAuthPrefs(data.httpAuthDynamicParams);
                        return true;
                    }





                    case SET_RAW_HEADERS_ACCESS_ORDINAL: {

                        NetworkServiceSetRawHeadersAccessParams data =
                                NetworkServiceSetRawHeadersAccessParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setRawHeadersAccess(data.processId, data.origins);
                        return true;
                    }





                    case GET_NETWORK_CHANGE_MANAGER_ORDINAL: {

                        NetworkServiceGetNetworkChangeManagerParams data =
                                NetworkServiceGetNetworkChangeManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNetworkChangeManager(data.networkChangeManager);
                        return true;
                    }





                    case GET_NETWORK_QUALITY_ESTIMATOR_MANAGER_ORDINAL: {

                        NetworkServiceGetNetworkQualityEstimatorManagerParams data =
                                NetworkServiceGetNetworkQualityEstimatorManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNetworkQualityEstimatorManager(data.networkQualityEstimatorManager);
                        return true;
                    }





                    case GET_DNS_CONFIG_CHANGE_MANAGER_ORDINAL: {

                        NetworkServiceGetDnsConfigChangeManagerParams data =
                                NetworkServiceGetDnsConfigChangeManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getDnsConfigChangeManager(data.dnsConfigChangeManager);
                        return true;
                    }









                    case UPDATE_SIGNED_TREE_HEAD_ORDINAL: {

                        NetworkServiceUpdateSignedTreeHeadParams data =
                                NetworkServiceUpdateSignedTreeHeadParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateSignedTreeHead(data.signedTreeHead);
                        return true;
                    }





                    case UPDATE_CRL_SET_ORDINAL: {

                        NetworkServiceUpdateCrlSetParams data =
                                NetworkServiceUpdateCrlSetParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateCrlSet(data.crlSet);
                        return true;
                    }





                    case ON_CERT_DB_CHANGED_ORDINAL: {

                        NetworkServiceOnCertDbChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onCertDbChanged();
                        return true;
                    }





                    case ADD_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL: {

                        NetworkServiceAddCorbExceptionForPluginParams data =
                                NetworkServiceAddCorbExceptionForPluginParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addCorbExceptionForPlugin(data.processId);
                        return true;
                    }





                    case REMOVE_CORB_EXCEPTION_FOR_PLUGIN_ORDINAL: {

                        NetworkServiceRemoveCorbExceptionForPluginParams data =
                                NetworkServiceRemoveCorbExceptionForPluginParams.deserialize(messageWithHeader.getPayload());

                        getImpl().removeCorbExceptionForPlugin(data.processId);
                        return true;
                    }





                    case ON_MEMORY_PRESSURE_ORDINAL: {

                        NetworkServiceOnMemoryPressureParams data =
                                NetworkServiceOnMemoryPressureParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onMemoryPressure(data.memoryPressureLevel);
                        return true;
                    }





                    case ON_APPLICATION_STATE_CHANGE_ORDINAL: {

                        NetworkServiceOnApplicationStateChangeParams data =
                                NetworkServiceOnApplicationStateChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onApplicationStateChange(data.state);
                        return true;
                    }





                    case SET_ENVIRONMENT_ORDINAL: {

                        NetworkServiceSetEnvironmentParams data =
                                NetworkServiceSetEnvironmentParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setEnvironment(data.environment);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkService_Internal.MANAGER, messageWithHeader, receiver);































                    case GET_TOTAL_NETWORK_USAGES_ORDINAL: {

                        NetworkServiceGetTotalNetworkUsagesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getTotalNetworkUsages(new NetworkServiceGetTotalNetworkUsagesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_NETWORK_LIST_ORDINAL: {

                        NetworkServiceGetNetworkListParams data =
                                NetworkServiceGetNetworkListParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNetworkList(data.policy, new NetworkServiceGetNetworkListResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkServiceSetClientParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkServiceClient client;
        public NetworkServiceParams params;

        private NetworkServiceSetClientParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceSetClientParams() {
            this(0);
        }

        public static NetworkServiceSetClientParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceSetClientParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceSetClientParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceSetClientParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceSetClientParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, NetworkServiceClient.MANAGER);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.params = NetworkServiceParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, NetworkServiceClient.MANAGER);
            
            encoder0.encode(this.params, 16, false);
        }
    }



    
    static final class NetworkServiceStartNetLogParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.File file;
        public int captureMode;
        public com.vccorp.mojo_base.mojom.DictionaryValue constants;

        private NetworkServiceStartNetLogParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceStartNetLogParams() {
            this(0);
        }

        public static NetworkServiceStartNetLogParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceStartNetLogParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceStartNetLogParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceStartNetLogParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceStartNetLogParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.file = com.vccorp.mojo_base.mojom.File.decode(decoder1);
                    }
                    {
                        
                    result.captureMode = decoder0.readInt(16);
                        NetLogCaptureMode.validate(result.captureMode);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.constants = com.vccorp.mojo_base.mojom.DictionaryValue.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.file, 8, false);
            
            encoder0.encode(this.captureMode, 16);
            
            encoder0.encode(this.constants, 24, false);
        }
    }



    
    static final class NetworkServiceSetSslKeyLogFileParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.FilePath file;

        private NetworkServiceSetSslKeyLogFileParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceSetSslKeyLogFileParams() {
            this(0);
        }

        public static NetworkServiceSetSslKeyLogFileParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceSetSslKeyLogFileParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceSetSslKeyLogFileParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceSetSslKeyLogFileParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceSetSslKeyLogFileParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.file = com.vccorp.mojo_base.mojom.FilePath.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.file, 8, false);
        }
    }



    
    static final class NetworkServiceCreateNetworkContextParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<NetworkContext> context;
        public NetworkContextParams params;

        private NetworkServiceCreateNetworkContextParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceCreateNetworkContextParams() {
            this(0);
        }

        public static NetworkServiceCreateNetworkContextParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceCreateNetworkContextParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceCreateNetworkContextParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceCreateNetworkContextParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceCreateNetworkContextParams(elementsOrVersion);
                    {
                        
                    result.context = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.params = NetworkContextParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.context, 8, false);
            
            encoder0.encode(this.params, 16, false);
        }
    }



    
    static final class NetworkServiceConfigureStubHostResolverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean stubResolverEnabled;
        public DnsOverHttpsServer[] dnsOverHttpsServers;

        private NetworkServiceConfigureStubHostResolverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceConfigureStubHostResolverParams() {
            this(0);
        }

        public static NetworkServiceConfigureStubHostResolverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceConfigureStubHostResolverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceConfigureStubHostResolverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceConfigureStubHostResolverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceConfigureStubHostResolverParams(elementsOrVersion);
                    {
                        
                    result.stubResolverEnabled = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    if (decoder1 == null) {
                        result.dnsOverHttpsServers = null;
                    } else {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.dnsOverHttpsServers = new DnsOverHttpsServer[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.dnsOverHttpsServers[i1] = DnsOverHttpsServer.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.stubResolverEnabled, 8, 0);
            
            if (this.dnsOverHttpsServers == null) {
                encoder0.encodeNullPointer(16, true);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.dnsOverHttpsServers.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.dnsOverHttpsServers.length; ++i0) {
                    
                    encoder1.encode(this.dnsOverHttpsServers[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkServiceDisableQuicParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceDisableQuicParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceDisableQuicParams() {
            this(0);
        }

        public static NetworkServiceDisableQuicParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceDisableQuicParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceDisableQuicParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceDisableQuicParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceDisableQuicParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceSetUpHttpAuthParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpAuthStaticParams httpAuthStaticParams;

        private NetworkServiceSetUpHttpAuthParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceSetUpHttpAuthParams() {
            this(0);
        }

        public static NetworkServiceSetUpHttpAuthParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceSetUpHttpAuthParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceSetUpHttpAuthParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceSetUpHttpAuthParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceSetUpHttpAuthParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.httpAuthStaticParams = HttpAuthStaticParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.httpAuthStaticParams, 8, false);
        }
    }



    
    static final class NetworkServiceConfigureHttpAuthPrefsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HttpAuthDynamicParams httpAuthDynamicParams;

        private NetworkServiceConfigureHttpAuthPrefsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceConfigureHttpAuthPrefsParams() {
            this(0);
        }

        public static NetworkServiceConfigureHttpAuthPrefsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceConfigureHttpAuthPrefsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceConfigureHttpAuthPrefsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceConfigureHttpAuthPrefsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceConfigureHttpAuthPrefsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.httpAuthDynamicParams = HttpAuthDynamicParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.httpAuthDynamicParams, 8, false);
        }
    }



    
    static final class NetworkServiceSetRawHeadersAccessParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;
        public com.vccorp.url.mojom.Origin[] origins;

        private NetworkServiceSetRawHeadersAccessParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceSetRawHeadersAccessParams() {
            this(0);
        }

        public static NetworkServiceSetRawHeadersAccessParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceSetRawHeadersAccessParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceSetRawHeadersAccessParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceSetRawHeadersAccessParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceSetRawHeadersAccessParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.origins = new com.vccorp.url.mojom.Origin[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.origins[i1] = com.vccorp.url.mojom.Origin.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
            
            if (this.origins == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.origins.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.origins.length; ++i0) {
                    
                    encoder1.encode(this.origins[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkServiceGetNetworkChangeManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<NetworkChangeManager> networkChangeManager;

        private NetworkServiceGetNetworkChangeManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetNetworkChangeManagerParams() {
            this(0);
        }

        public static NetworkServiceGetNetworkChangeManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetNetworkChangeManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetNetworkChangeManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetNetworkChangeManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetNetworkChangeManagerParams(elementsOrVersion);
                    {
                        
                    result.networkChangeManager = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.networkChangeManager, 8, false);
        }
    }



    
    static final class NetworkServiceGetNetworkQualityEstimatorManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<NetworkQualityEstimatorManager> networkQualityEstimatorManager;

        private NetworkServiceGetNetworkQualityEstimatorManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetNetworkQualityEstimatorManagerParams() {
            this(0);
        }

        public static NetworkServiceGetNetworkQualityEstimatorManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetNetworkQualityEstimatorManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetNetworkQualityEstimatorManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetNetworkQualityEstimatorManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetNetworkQualityEstimatorManagerParams(elementsOrVersion);
                    {
                        
                    result.networkQualityEstimatorManager = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.networkQualityEstimatorManager, 8, false);
        }
    }



    
    static final class NetworkServiceGetDnsConfigChangeManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<DnsConfigChangeManager> dnsConfigChangeManager;

        private NetworkServiceGetDnsConfigChangeManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetDnsConfigChangeManagerParams() {
            this(0);
        }

        public static NetworkServiceGetDnsConfigChangeManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetDnsConfigChangeManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetDnsConfigChangeManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetDnsConfigChangeManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetDnsConfigChangeManagerParams(elementsOrVersion);
                    {
                        
                    result.dnsConfigChangeManager = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.dnsConfigChangeManager, 8, false);
        }
    }



    
    static final class NetworkServiceGetTotalNetworkUsagesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceGetTotalNetworkUsagesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetTotalNetworkUsagesParams() {
            this(0);
        }

        public static NetworkServiceGetTotalNetworkUsagesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetTotalNetworkUsagesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetTotalNetworkUsagesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetTotalNetworkUsagesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetTotalNetworkUsagesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceGetTotalNetworkUsagesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkUsage[] totalNetworkUsages;

        private NetworkServiceGetTotalNetworkUsagesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetTotalNetworkUsagesResponseParams() {
            this(0);
        }

        public static NetworkServiceGetTotalNetworkUsagesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetTotalNetworkUsagesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetTotalNetworkUsagesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetTotalNetworkUsagesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetTotalNetworkUsagesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.totalNetworkUsages = new NetworkUsage[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.totalNetworkUsages[i1] = NetworkUsage.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.totalNetworkUsages == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.totalNetworkUsages.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.totalNetworkUsages.length; ++i0) {
                    
                    encoder1.encode(this.totalNetworkUsages[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class NetworkServiceGetTotalNetworkUsagesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkService.GetTotalNetworkUsagesResponse mCallback;

        NetworkServiceGetTotalNetworkUsagesResponseParamsForwardToCallback(NetworkService.GetTotalNetworkUsagesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_TOTAL_NETWORK_USAGES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceGetTotalNetworkUsagesResponseParams response = NetworkServiceGetTotalNetworkUsagesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.totalNetworkUsages);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceGetTotalNetworkUsagesResponseParamsProxyToResponder implements NetworkService.GetTotalNetworkUsagesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceGetTotalNetworkUsagesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkUsage[] totalNetworkUsages) {
            NetworkServiceGetTotalNetworkUsagesResponseParams _response = new NetworkServiceGetTotalNetworkUsagesResponseParams();

            _response.totalNetworkUsages = totalNetworkUsages;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_TOTAL_NETWORK_USAGES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceGetNetworkListParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int policy;

        private NetworkServiceGetNetworkListParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetNetworkListParams() {
            this(0);
        }

        public static NetworkServiceGetNetworkListParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetNetworkListParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetNetworkListParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetNetworkListParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetNetworkListParams(elementsOrVersion);
                    {
                        
                    result.policy = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.policy, 8);
        }
    }



    
    static final class NetworkServiceGetNetworkListResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkInterface[] networks;

        private NetworkServiceGetNetworkListResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceGetNetworkListResponseParams() {
            this(0);
        }

        public static NetworkServiceGetNetworkListResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceGetNetworkListResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceGetNetworkListResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceGetNetworkListResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceGetNetworkListResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    if (decoder1 == null) {
                        result.networks = null;
                    } else {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.networks = new NetworkInterface[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.networks[i1] = NetworkInterface.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.networks == null) {
                encoder0.encodeNullPointer(8, true);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.networks.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.networks.length; ++i0) {
                    
                    encoder1.encode(this.networks[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class NetworkServiceGetNetworkListResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkService.GetNetworkListResponse mCallback;

        NetworkServiceGetNetworkListResponseParamsForwardToCallback(NetworkService.GetNetworkListResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_NETWORK_LIST_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkServiceGetNetworkListResponseParams response = NetworkServiceGetNetworkListResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.networks);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkServiceGetNetworkListResponseParamsProxyToResponder implements NetworkService.GetNetworkListResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkServiceGetNetworkListResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkInterface[] networks) {
            NetworkServiceGetNetworkListResponseParams _response = new NetworkServiceGetNetworkListResponseParams();

            _response.networks = networks;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_NETWORK_LIST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkServiceUpdateSignedTreeHeadParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SignedTreeHead signedTreeHead;

        private NetworkServiceUpdateSignedTreeHeadParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceUpdateSignedTreeHeadParams() {
            this(0);
        }

        public static NetworkServiceUpdateSignedTreeHeadParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceUpdateSignedTreeHeadParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceUpdateSignedTreeHeadParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceUpdateSignedTreeHeadParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceUpdateSignedTreeHeadParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.signedTreeHead = SignedTreeHead.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.signedTreeHead, 8, false);
        }
    }



    
    static final class NetworkServiceUpdateCrlSetParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.ReadOnlyBuffer crlSet;

        private NetworkServiceUpdateCrlSetParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceUpdateCrlSetParams() {
            this(0);
        }

        public static NetworkServiceUpdateCrlSetParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceUpdateCrlSetParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceUpdateCrlSetParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceUpdateCrlSetParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceUpdateCrlSetParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.crlSet = com.vccorp.mojo_base.mojom.ReadOnlyBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.crlSet, 8, false);
        }
    }



    
    static final class NetworkServiceOnCertDbChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkServiceOnCertDbChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceOnCertDbChangedParams() {
            this(0);
        }

        public static NetworkServiceOnCertDbChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceOnCertDbChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceOnCertDbChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceOnCertDbChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceOnCertDbChangedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkServiceAddCorbExceptionForPluginParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;

        private NetworkServiceAddCorbExceptionForPluginParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceAddCorbExceptionForPluginParams() {
            this(0);
        }

        public static NetworkServiceAddCorbExceptionForPluginParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceAddCorbExceptionForPluginParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceAddCorbExceptionForPluginParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceAddCorbExceptionForPluginParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceAddCorbExceptionForPluginParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
        }
    }



    
    static final class NetworkServiceRemoveCorbExceptionForPluginParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int processId;

        private NetworkServiceRemoveCorbExceptionForPluginParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceRemoveCorbExceptionForPluginParams() {
            this(0);
        }

        public static NetworkServiceRemoveCorbExceptionForPluginParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceRemoveCorbExceptionForPluginParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceRemoveCorbExceptionForPluginParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceRemoveCorbExceptionForPluginParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceRemoveCorbExceptionForPluginParams(elementsOrVersion);
                    {
                        
                    result.processId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.processId, 8);
        }
    }



    
    static final class NetworkServiceOnMemoryPressureParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int memoryPressureLevel;

        private NetworkServiceOnMemoryPressureParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceOnMemoryPressureParams() {
            this(0);
        }

        public static NetworkServiceOnMemoryPressureParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceOnMemoryPressureParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceOnMemoryPressureParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceOnMemoryPressureParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceOnMemoryPressureParams(elementsOrVersion);
                    {
                        
                    result.memoryPressureLevel = decoder0.readInt(8);
                        com.vccorp.mojo_base.mojom.MemoryPressureLevel.validate(result.memoryPressureLevel);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.memoryPressureLevel, 8);
        }
    }



    
    static final class NetworkServiceOnApplicationStateChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int state;

        private NetworkServiceOnApplicationStateChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceOnApplicationStateChangeParams() {
            this(0);
        }

        public static NetworkServiceOnApplicationStateChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceOnApplicationStateChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceOnApplicationStateChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceOnApplicationStateChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceOnApplicationStateChangeParams(elementsOrVersion);
                    {
                        
                    result.state = decoder0.readInt(8);
                        com.vccorp.mojo_base.mojom.ApplicationState.validate(result.state);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8);
        }
    }



    
    static final class NetworkServiceSetEnvironmentParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public EnvironmentVariable[] environment;

        private NetworkServiceSetEnvironmentParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkServiceSetEnvironmentParams() {
            this(0);
        }

        public static NetworkServiceSetEnvironmentParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkServiceSetEnvironmentParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkServiceSetEnvironmentParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkServiceSetEnvironmentParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkServiceSetEnvironmentParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.environment = new EnvironmentVariable[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.environment[i1] = EnvironmentVariable.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.environment == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.environment.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.environment.length; ++i0) {
                    
                    encoder1.encode(this.environment[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



}
