
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_service_test.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface NetworkServiceTest extends com.vccorp.mojo.bindings.Interface {



    public static final class ShouldRequireCt {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int RESET = 0;
        public static final int REQUIRE = 1;
        public static final int DONT_REQUIRE = 2;

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private ShouldRequireCt() {}
    }


    public interface Proxy extends NetworkServiceTest, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<NetworkServiceTest, NetworkServiceTest.Proxy> MANAGER = NetworkServiceTest_Internal.MANAGER;


    void addRules(
Rule[] rules, 
AddRulesResponse callback);

    interface AddRulesResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void simulateNetworkChange(
int type, 
SimulateNetworkChangeResponse callback);

    interface SimulateNetworkChangeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void simulateNetworkQualityChange(
int type, 
SimulateNetworkQualityChangeResponse callback);

    interface SimulateNetworkQualityChangeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void simulateCrash(
);



    void mockCertVerifierSetDefaultResult(
int defaultResult, 
MockCertVerifierSetDefaultResultResponse callback);

    interface MockCertVerifierSetDefaultResultResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void mockCertVerifierAddResultForCertAndHost(
X509Certificate cert, String hostPattern, CertVerifyResult verifyResult, int rv, 
MockCertVerifierAddResultForCertAndHostResponse callback);

    interface MockCertVerifierAddResultForCertAndHostResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void setShouldRequireCt(
int required, 
SetShouldRequireCtResponse callback);

    interface SetShouldRequireCtResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void setTransportSecurityStateSource(
short reportingPort, 
SetTransportSecurityStateSourceResponse callback);

    interface SetTransportSecurityStateSourceResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void crashOnResolveHost(
String host);



    void crashOnGetCookieList(
);



    void getLatestMemoryPressureLevel(

GetLatestMemoryPressureLevelResponse callback);

    interface GetLatestMemoryPressureLevelResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void getEnvironmentVariableValue(
String name, 
GetEnvironmentVariableValueResponse callback);

    interface GetEnvironmentVariableValueResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<String> { }


}
