
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_quality_estimator_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkQualityEstimatorManagerClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkQualityEstimatorManagerClient, NetworkQualityEstimatorManagerClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkQualityEstimatorManagerClient, NetworkQualityEstimatorManagerClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkQualityEstimatorManagerClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkQualityEstimatorManagerClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkQualityEstimatorManagerClient[] buildArray(int size) {
          return new NetworkQualityEstimatorManagerClient[size];
        }
    };


    private static final int ON_NETWORK_QUALITY_CHANGED_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkQualityEstimatorManagerClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onNetworkQualityChanged(
int type, com.vccorp.mojo_base.mojom.TimeDelta httpRtt, com.vccorp.mojo_base.mojom.TimeDelta transportRtt, int downlinkBandwidthKbps) {

            NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams _message = new NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams();

            _message.type = type;

            _message.httpRtt = httpRtt;

            _message.transportRtt = transportRtt;

            _message.downlinkBandwidthKbps = downlinkBandwidthKbps;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_NETWORK_QUALITY_CHANGED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkQualityEstimatorManagerClient> {

        Stub(com.vccorp.mojo.system.Core core, NetworkQualityEstimatorManagerClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkQualityEstimatorManagerClient_Internal.MANAGER, messageWithHeader);





                    case ON_NETWORK_QUALITY_CHANGED_ORDINAL: {

                        NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams data =
                                NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onNetworkQualityChanged(data.type, data.httpRtt, data.transportRtt, data.downlinkBandwidthKbps);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkQualityEstimatorManagerClient_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int type;
        public com.vccorp.mojo_base.mojom.TimeDelta httpRtt;
        public com.vccorp.mojo_base.mojom.TimeDelta transportRtt;
        public int downlinkBandwidthKbps;

        private NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams() {
            this(0);
        }

        public static NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkQualityEstimatorManagerClientOnNetworkQualityChangedParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readInt(8);
                        EffectiveConnectionType.validate(result.type);
                    }
                    {
                        
                    result.downlinkBandwidthKbps = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.httpRtt = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.transportRtt = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8);
            
            encoder0.encode(this.downlinkBandwidthKbps, 12);
            
            encoder0.encode(this.httpRtt, 16, false);
            
            encoder0.encode(this.transportRtt, 24, false);
        }
    }



}
