
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface NetworkContext extends com.vccorp.mojo.bindings.Interface {



    public static final class DomainReliabilityClearMode {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int CLEAR_CONTEXTS = 0;
        public static final int CLEAR_BEACONS = 1; // CLEAR_CONTEXTS + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 1;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private DomainReliabilityClearMode() {}
    }


    public interface Proxy extends NetworkContext, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<NetworkContext, NetworkContext.Proxy> MANAGER = NetworkContext_Internal.MANAGER;


    void setClient(
NetworkContextClient client);



    void createUrlLoaderFactory(
com.vccorp.mojo.bindings.InterfaceRequest<UrlLoaderFactory> urlLoaderFactory, UrlLoaderFactoryParams params);



    void resetUrlLoaderFactories(
);



    void getCookieManager(
com.vccorp.mojo.bindings.InterfaceRequest<CookieManager> cookieManager);



    void getRestrictedCookieManager(
com.vccorp.mojo.bindings.InterfaceRequest<RestrictedCookieManager> restrictedCookieManager, com.vccorp.url.mojom.Origin origin);



    void clearNetworkingHistorySince(
com.vccorp.mojo_base.mojom.Time startTime,
ClearNetworkingHistorySinceResponse callback);

    interface ClearNetworkingHistorySinceResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearHttpCache(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime, ClearDataFilter filter,
ClearHttpCacheResponse callback);

    interface ClearHttpCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void computeHttpCacheSize(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime,
ComputeHttpCacheSizeResponse callback);

    interface ComputeHttpCacheSizeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Boolean, Long> { }



    void notifyExternalCacheHit(
com.vccorp.url.mojom.Url url, String httpMethod, com.vccorp.url.mojom.Origin topFrameOrigin);



    void writeCacheMetadata(
com.vccorp.url.mojom.Url url, int priority, com.vccorp.mojo_base.mojom.Time expectedResponseTime, byte[] data);



    void clearChannelIds(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime, ClearDataFilter filter,
ClearChannelIdsResponse callback);

    interface ClearChannelIdsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearHostCache(
ClearDataFilter filter, 
ClearHostCacheResponse callback);

    interface ClearHostCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearHttpAuthCache(
com.vccorp.mojo_base.mojom.Time startTime,
ClearHttpAuthCacheResponse callback);

    interface ClearHttpAuthCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearReportingCacheReports(
ClearDataFilter filter, 
ClearReportingCacheReportsResponse callback);

    interface ClearReportingCacheReportsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearReportingCacheClients(
ClearDataFilter filter, 
ClearReportingCacheClientsResponse callback);

    interface ClearReportingCacheClientsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearNetworkErrorLogging(
ClearDataFilter filter, 
ClearNetworkErrorLoggingResponse callback);

    interface ClearNetworkErrorLoggingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearDomainReliability(
ClearDataFilter filter, int mode, 
ClearDomainReliabilityResponse callback);

    interface ClearDomainReliabilityResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void getDomainReliabilityJson(

GetDomainReliabilityJsonResponse callback);

    interface GetDomainReliabilityJsonResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<com.vccorp.mojo_base.mojom.Value> { }



    void queueReport(
String type, String group, com.vccorp.url.mojom.Url url, String userAgent, com.vccorp.mojo_base.mojom.DictionaryValue body);



    void queueSignedExchangeReport(
SignedExchangeReport report);



    void closeAllConnections(

CloseAllConnectionsResponse callback);

    interface CloseAllConnectionsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void closeIdleConnections(

CloseIdleConnectionsResponse callback);

    interface CloseIdleConnectionsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void setNetworkConditions(
com.vccorp.mojo_base.mojom.UnguessableToken throttlingProfileId, NetworkConditions conditions);



    void setAcceptLanguage(
String newAcceptLanguage);



    void setEnableReferrers(
boolean enableReferrers);



    void setCtPolicy(
String[] requiredHosts, String[] excludedHosts, String[] excludedSpkis, String[] excludedLegacySpkis);



    void addExpectCt(
String host, com.vccorp.mojo_base.mojom.Time expiry, boolean enforce, com.vccorp.url.mojom.Url reportUri,
AddExpectCtResponse callback);

    interface AddExpectCtResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void setExpectCtTestReport(
com.vccorp.url.mojom.Url reportUri,
SetExpectCtTestReportResponse callback);

    interface SetExpectCtTestReportResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void getExpectCtState(
String domain, 
GetExpectCtStateResponse callback);

    interface GetExpectCtStateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<com.vccorp.mojo_base.mojom.DictionaryValue> { }



    void createUdpSocket(
com.vccorp.mojo.bindings.InterfaceRequest<UdpSocket> request, UdpSocketReceiver receiver);



    void createTcpServerSocket(
IpEndPoint localAddr, int backlog, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpServerSocket> socket,
CreateTcpServerSocketResponse callback);

    interface CreateTcpServerSocketResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, IpEndPoint> { }



    void createTcpConnectedSocket(
IpEndPoint localAddr, AddressList remoteAddrList, TcpConnectedSocketOptions tcpConnectedSocketOptions, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpConnectedSocket> socket, SocketObserver observer,
CreateTcpConnectedSocketResponse callback);

    interface CreateTcpConnectedSocketResponse extends com.vccorp.mojo.bindings.Callbacks.Callback5<Integer, IpEndPoint, IpEndPoint, com.vccorp.mojo.system.DataPipe.ConsumerHandle, com.vccorp.mojo.system.DataPipe.ProducerHandle> { }



    void createTcpBoundSocket(
IpEndPoint localAddr, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpBoundSocket> socket,
CreateTcpBoundSocketResponse callback);

    interface CreateTcpBoundSocketResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, IpEndPoint> { }



    void createProxyResolvingSocketFactory(
com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolvingSocketFactory> factory);



    void lookUpProxyForUrl(
com.vccorp.url.mojom.Url url, ProxyLookupClient proxyLookupClient);



    void forceReloadProxyConfig(

ForceReloadProxyConfigResponse callback);

    interface ForceReloadProxyConfigResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void clearBadProxiesCache(

ClearBadProxiesCacheResponse callback);

    interface ClearBadProxiesCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void createWebSocket(
com.vccorp.mojo.bindings.InterfaceRequest<WebSocket> request, int processId, int renderFrameId, com.vccorp.url.mojom.Origin origin, int options, AuthenticationHandler authHandler, TrustedHeaderClient headerClient);



    void createNetLogExporter(
com.vccorp.mojo.bindings.InterfaceRequest<NetLogExporter> exporter);



    void preconnectSockets(
int numStreams, com.vccorp.url.mojom.Url url, int loadFlags, boolean privacyModeEnabled);



    void createP2pSocketManager(
P2pTrustedSocketManagerClient client, com.vccorp.mojo.bindings.InterfaceRequest<P2pTrustedSocketManager> trustedSocketManager, com.vccorp.mojo.bindings.InterfaceRequest<P2pSocketManager> socketManager);



    void createMdnsResponder(
com.vccorp.mojo.bindings.InterfaceRequest<MdnsResponder> responderRequest);



    void resolveHost(
HostPortPair host, ResolveHostParameters optionalParameters, ResolveHostClient responseClient);



    void createHostResolver(
DnsConfigOverrides configOverrides, com.vccorp.mojo.bindings.InterfaceRequest<HostResolver> hostResolver);



    void verifyCertForSignedExchange(
X509Certificate certificate, com.vccorp.url.mojom.Url url, String ocspResponse, String sctList,
VerifyCertForSignedExchangeResponse callback);

    interface VerifyCertForSignedExchangeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback3<Integer, CertVerifyResult, CtVerifyResult> { }



    void addHsts(
String host, com.vccorp.mojo_base.mojom.Time expiry, boolean includeSubdomains,
AddHstsResponse callback);

    interface AddHstsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void isHstsActiveForHost(
String host, 
IsHstsActiveForHostResponse callback);

    interface IsHstsActiveForHostResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void getHstsState(
String domain, 
GetHstsStateResponse callback);

    interface GetHstsStateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<com.vccorp.mojo_base.mojom.DictionaryValue> { }



    void setCorsOriginAccessListsForOrigin(
com.vccorp.url.mojom.Origin sourceOrigin, CorsOriginPattern[] allowPatterns, CorsOriginPattern[] blockPatterns,
SetCorsOriginAccessListsForOriginResponse callback);

    interface SetCorsOriginAccessListsForOriginResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void deleteDynamicDataForHost(
String host, 
DeleteDynamicDataForHostResponse callback);

    interface DeleteDynamicDataForHostResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void saveHttpAuthCache(

SaveHttpAuthCacheResponse callback);

    interface SaveHttpAuthCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<com.vccorp.mojo_base.mojom.UnguessableToken> { }



    void loadHttpAuthCache(
com.vccorp.mojo_base.mojom.UnguessableToken cacheKey,
LoadHttpAuthCacheResponse callback);

    interface LoadHttpAuthCacheResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void lookupBasicAuthCredentials(
com.vccorp.url.mojom.Url url,
LookupBasicAuthCredentialsResponse callback);

    interface LookupBasicAuthCredentialsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<AuthCredentials> { }



    void enableStaticKeyPinningForTesting(

EnableStaticKeyPinningForTestingResponse callback);

    interface EnableStaticKeyPinningForTestingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void setFailingHttpTransactionForTesting(
int rv, 
SetFailingHttpTransactionForTestingResponse callback);

    interface SetFailingHttpTransactionForTestingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void verifyCertificateForTesting(
X509Certificate certificate, String hostname, String ocspResponse, 
VerifyCertificateForTestingResponse callback);

    interface VerifyCertificateForTestingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void addDomainReliabilityContextForTesting(
com.vccorp.url.mojom.Url origin, com.vccorp.url.mojom.Url uploadUrl,
AddDomainReliabilityContextForTestingResponse callback);

    interface AddDomainReliabilityContextForTestingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void forceDomainReliabilityUploadsForTesting(

ForceDomainReliabilityUploadsForTestingResponse callback);

    interface ForceDomainReliabilityUploadsForTestingResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }


}
