
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_change_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ConnectionSubtype {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int SUBTYPE_UNKNOWN = 0;
    public static final int SUBTYPE_NONE = 1; // SUBTYPE_UNKNOWN + 1
    public static final int SUBTYPE_OTHER = 2; // SUBTYPE_NONE + 1
    public static final int SUBTYPE_GSM = 3; // SUBTYPE_OTHER + 1
    public static final int SUBTYPE_IDEN = 4; // SUBTYPE_GSM + 1
    public static final int SUBTYPE_CDMA = 5; // SUBTYPE_IDEN + 1
    public static final int SUBTYPE_1XRTT = 6; // SUBTYPE_CDMA + 1
    public static final int SUBTYPE_GPRS = 7; // SUBTYPE_1XRTT + 1
    public static final int SUBTYPE_EDGE = 8; // SUBTYPE_GPRS + 1
    public static final int SUBTYPE_UMTS = 9; // SUBTYPE_EDGE + 1
    public static final int SUBTYPE_EVDO_REV_0 = 10; // SUBTYPE_UMTS + 1
    public static final int SUBTYPE_EVDO_REV_A = 11; // SUBTYPE_EVDO_REV_0 + 1
    public static final int SUBTYPE_HSPA = 12; // SUBTYPE_EVDO_REV_A + 1
    public static final int SUBTYPE_EVDO_REV_B = 13; // SUBTYPE_HSPA + 1
    public static final int SUBTYPE_HSDPA = 14; // SUBTYPE_EVDO_REV_B + 1
    public static final int SUBTYPE_HSUPA = 15; // SUBTYPE_HSDPA + 1
    public static final int SUBTYPE_EHRPD = 16; // SUBTYPE_HSUPA + 1
    public static final int SUBTYPE_HSPAP = 17; // SUBTYPE_EHRPD + 1
    public static final int SUBTYPE_LTE = 18; // SUBTYPE_HSPAP + 1
    public static final int SUBTYPE_LTE_ADVANCED = 19; // SUBTYPE_LTE + 1
    public static final int SUBTYPE_BLUETOOTH_1_2 = 20; // SUBTYPE_LTE_ADVANCED + 1
    public static final int SUBTYPE_BLUETOOTH_2_1 = 21; // SUBTYPE_BLUETOOTH_1_2 + 1
    public static final int SUBTYPE_BLUETOOTH_3_0 = 22; // SUBTYPE_BLUETOOTH_2_1 + 1
    public static final int SUBTYPE_BLUETOOTH_4_0 = 23; // SUBTYPE_BLUETOOTH_3_0 + 1
    public static final int SUBTYPE_ETHERNET = 24; // SUBTYPE_BLUETOOTH_4_0 + 1
    public static final int SUBTYPE_FAST_ETHERNET = 25; // SUBTYPE_ETHERNET + 1
    public static final int SUBTYPE_GIGABIT_ETHERNET = 26; // SUBTYPE_FAST_ETHERNET + 1
    public static final int SUBTYPE_10_GIGABIT_ETHERNET = 27; // SUBTYPE_GIGABIT_ETHERNET + 1
    public static final int SUBTYPE_WIFI_B = 28; // SUBTYPE_10_GIGABIT_ETHERNET + 1
    public static final int SUBTYPE_WIFI_G = 29; // SUBTYPE_WIFI_B + 1
    public static final int SUBTYPE_WIFI_N = 30; // SUBTYPE_WIFI_G + 1
    public static final int SUBTYPE_WIFI_AC = 31; // SUBTYPE_WIFI_N + 1
    public static final int SUBTYPE_WIFI_AD = 32; // SUBTYPE_WIFI_AC + 1
    public static final int SUBTYPE_LAST = ConnectionSubtype.SUBTYPE_WIFI_AD;

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 32;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ConnectionSubtype() {}
}