
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/cookie_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CanonicalCookie extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String name;
    public String value;
    public String domain;
    public String path;
    public com.vccorp.mojo_base.mojom.Time creation;
    public com.vccorp.mojo_base.mojom.Time expiry;
    public com.vccorp.mojo_base.mojom.Time lastAccess;
    public boolean secure;
    public boolean httponly;
    public int siteRestrictions;
    public int priority;

    private CanonicalCookie(int version) {
        super(STRUCT_SIZE, version);
        this.secure = (boolean) false;
        this.httponly = (boolean) false;
        this.siteRestrictions = (int) CookieSameSite.NO_RESTRICTION;
        this.priority = (int) CookiePriority.MEDIUM;
    }

    public CanonicalCookie() {
        this(0);
    }

    public static CanonicalCookie deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CanonicalCookie deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CanonicalCookie decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CanonicalCookie result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CanonicalCookie(elementsOrVersion);
                {
                    
                result.name = decoder0.readString(8, false);
                }
                {
                    
                result.value = decoder0.readString(16, false);
                }
                {
                    
                result.domain = decoder0.readString(24, false);
                }
                {
                    
                result.path = decoder0.readString(32, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.creation = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.expiry = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.lastAccess = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }
                {
                    
                result.secure = decoder0.readBoolean(64, 0);
                }
                {
                    
                result.httponly = decoder0.readBoolean(64, 1);
                }
                {
                    
                result.siteRestrictions = decoder0.readInt(68);
                    CookieSameSite.validate(result.siteRestrictions);
                }
                {
                    
                result.priority = decoder0.readInt(72);
                    CookiePriority.validate(result.priority);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.name, 8, false);
        
        encoder0.encode(this.value, 16, false);
        
        encoder0.encode(this.domain, 24, false);
        
        encoder0.encode(this.path, 32, false);
        
        encoder0.encode(this.creation, 40, false);
        
        encoder0.encode(this.expiry, 48, false);
        
        encoder0.encode(this.lastAccess, 56, false);
        
        encoder0.encode(this.secure, 64, 0);
        
        encoder0.encode(this.httponly, 64, 1);
        
        encoder0.encode(this.siteRestrictions, 68);
        
        encoder0.encode(this.priority, 72);
    }
}