// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package com.vccorp.mojo.system.impl;

import com.vccorp.mojo.system.DataPipe.ConsumerHandle;
import com.vccorp.mojo.system.DataPipe.ProducerHandle;
import com.vccorp.mojo.system.MessagePipeHandle;
import com.vccorp.mojo.system.SharedBufferHandle;
import com.vccorp.mojo.system.UntypedHandle;

import org.chromium.mojo.system.impl.CoreImpl;

/**
 Implementation of {@link UntypedHandle}.
 */
import org.chromium.mojo.system.impl.CoreImpl;
import org.chromium.mojo.system.impl.HandleBase;

public class UntypedHandleImpl extends HandleBase implements UntypedHandle {
    /**
     * @see HandleBase#HandleBase(CoreImpl, int)
     */
    public UntypedHandleImpl(CoreImpl core, int mojoHandle) {
        super(core, mojoHandle);
    }

    /**
     * @see HandleBase#HandleBase(HandleBase)
     */
    public UntypedHandleImpl(HandleBase handle) {
        super(handle);
    }

    /**
     * @see com.vccorp.mojo.system.UntypedHandle#pass()
     */
    @Override
    public UntypedHandle pass() {
        return new UntypedHandleImpl(this);
    }

    /**
     * @see com.vccorp.mojo.system.UntypedHandle#toMessagePipeHandle()
     */
    @Override
    public MessagePipeHandle toMessagePipeHandle() {
        return new MessagePipeHandleImpl(this);
    }

    /**
     * @see com.vccorp.mojo.system.UntypedHandle#toDataPipeConsumerHandle()
     */
    @Override
    public ConsumerHandle toDataPipeConsumerHandle() {
        return new DataPipeConsumerHandleImpl(this);
    }

    /**
     * @see com.vccorp.mojo.system.UntypedHandle#toDataPipeProducerHandle()
     */
    @Override
    public ProducerHandle toDataPipeProducerHandle() {
        return new DataPipeProducerHandleImpl(this);
    }

    /**
     * @see com.vccorp.mojo.system.UntypedHandle#toSharedBufferHandle()
     */
    @Override
    public SharedBufferHandle toSharedBufferHandle() {
        return new SharedBufferHandleImpl(this);
    }
}
