
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/media_session/public/mojom/audio_focus.mojom
//

package com.vccorp.media_session.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AudioFocusManager_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AudioFocusManager, AudioFocusManager.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AudioFocusManager, AudioFocusManager.Proxy>() {

        @Override
        public String getName() {
            return "media_session.mojom.AudioFocusManager";
        }

        @Override
        public int getVersion() {
          return 5;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AudioFocusManager impl) {
            return new Stub(core, impl);
        }

        @Override
        public AudioFocusManager[] buildArray(int size) {
          return new AudioFocusManager[size];
        }
    };


    private static final int REQUEST_AUDIO_FOCUS_ORDINAL = 0;

    private static final int REQUEST_GROUPED_AUDIO_FOCUS_ORDINAL = 4;

    private static final int GET_FOCUS_REQUESTS_ORDINAL = 1;

    private static final int ADD_OBSERVER_ORDINAL = 2;

    private static final int SET_SOURCE_NAME_ORDINAL = 3;

    private static final int SET_ENFORCEMENT_MODE_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AudioFocusManager.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void requestAudioFocus(
com.vccorp.mojo.bindings.InterfaceRequest<AudioFocusRequestClient> client, MediaSession mediaSession, MediaSessionInfo sessionInfo, int type,
RequestAudioFocusResponse callback) {

            AudioFocusManagerRequestAudioFocusParams _message = new AudioFocusManagerRequestAudioFocusParams();

            _message.client = client;

            _message.mediaSession = mediaSession;

            _message.sessionInfo = sessionInfo;

            _message.type = type;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_AUDIO_FOCUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new AudioFocusManagerRequestAudioFocusResponseParamsForwardToCallback(callback));

        }


        @Override
        public void requestGroupedAudioFocus(
com.vccorp.mojo.bindings.InterfaceRequest<AudioFocusRequestClient> client, MediaSession mediaSession, MediaSessionInfo sessionInfo, int type, com.vccorp.mojo_base.mojom.UnguessableToken groupId,
RequestGroupedAudioFocusResponse callback) {

            AudioFocusManagerRequestGroupedAudioFocusParams _message = new AudioFocusManagerRequestGroupedAudioFocusParams();

            _message.client = client;

            _message.mediaSession = mediaSession;

            _message.sessionInfo = sessionInfo;

            _message.type = type;

            _message.groupId = groupId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_GROUPED_AUDIO_FOCUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new AudioFocusManagerRequestGroupedAudioFocusResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getFocusRequests(

GetFocusRequestsResponse callback) {

            AudioFocusManagerGetFocusRequestsParams _message = new AudioFocusManagerGetFocusRequestsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_FOCUS_REQUESTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new AudioFocusManagerGetFocusRequestsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void addObserver(
AudioFocusObserver observer) {

            AudioFocusManagerAddObserverParams _message = new AudioFocusManagerAddObserverParams();

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_OBSERVER_ORDINAL)));

        }


        @Override
        public void setSourceName(
String name) {

            AudioFocusManagerSetSourceNameParams _message = new AudioFocusManagerSetSourceNameParams();

            _message.name = name;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_SOURCE_NAME_ORDINAL)));

        }


        @Override
        public void setEnforcementMode(
int mode) {

            AudioFocusManagerSetEnforcementModeParams _message = new AudioFocusManagerSetEnforcementModeParams();

            _message.mode = mode;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_ENFORCEMENT_MODE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AudioFocusManager> {

        Stub(com.vccorp.mojo.system.Core core, AudioFocusManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AudioFocusManager_Internal.MANAGER, messageWithHeader);











                    case ADD_OBSERVER_ORDINAL: {

                        AudioFocusManagerAddObserverParams data =
                                AudioFocusManagerAddObserverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addObserver(data.observer);
                        return true;
                    }





                    case SET_SOURCE_NAME_ORDINAL: {

                        AudioFocusManagerSetSourceNameParams data =
                                AudioFocusManagerSetSourceNameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setSourceName(data.name);
                        return true;
                    }





                    case SET_ENFORCEMENT_MODE_ORDINAL: {

                        AudioFocusManagerSetEnforcementModeParams data =
                                AudioFocusManagerSetEnforcementModeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setEnforcementMode(data.mode);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AudioFocusManager_Internal.MANAGER, messageWithHeader, receiver);







                    case REQUEST_AUDIO_FOCUS_ORDINAL: {

                        AudioFocusManagerRequestAudioFocusParams data =
                                AudioFocusManagerRequestAudioFocusParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestAudioFocus(data.client, data.mediaSession, data.sessionInfo, data.type, new AudioFocusManagerRequestAudioFocusResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case REQUEST_GROUPED_AUDIO_FOCUS_ORDINAL: {

                        AudioFocusManagerRequestGroupedAudioFocusParams data =
                                AudioFocusManagerRequestGroupedAudioFocusParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestGroupedAudioFocus(data.client, data.mediaSession, data.sessionInfo, data.type, data.groupId, new AudioFocusManagerRequestGroupedAudioFocusResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_FOCUS_REQUESTS_ORDINAL: {

                        AudioFocusManagerGetFocusRequestsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getFocusRequests(new AudioFocusManagerGetFocusRequestsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AudioFocusManagerRequestAudioFocusParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<AudioFocusRequestClient> client;
        public MediaSession mediaSession;
        public MediaSessionInfo sessionInfo;
        public int type;

        private AudioFocusManagerRequestAudioFocusParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerRequestAudioFocusParams() {
            this(0);
        }

        public static AudioFocusManagerRequestAudioFocusParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerRequestAudioFocusParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerRequestAudioFocusParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerRequestAudioFocusParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerRequestAudioFocusParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.mediaSession = decoder0.readServiceInterface(12, false, MediaSession.MANAGER);
                    }
                    {
                        
                    result.type = decoder0.readInt(20);
                        AudioFocusType.validate(result.type);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.sessionInfo = MediaSessionInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false);
            
            encoder0.encode(this.mediaSession, 12, false, MediaSession.MANAGER);
            
            encoder0.encode(this.type, 20);
            
            encoder0.encode(this.sessionInfo, 24, false);
        }
    }



    
    static final class AudioFocusManagerRequestAudioFocusResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken requestId;

        private AudioFocusManagerRequestAudioFocusResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerRequestAudioFocusResponseParams() {
            this(0);
        }

        public static AudioFocusManagerRequestAudioFocusResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerRequestAudioFocusResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerRequestAudioFocusResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerRequestAudioFocusResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerRequestAudioFocusResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.requestId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestId, 8, false);
        }
    }

    static class AudioFocusManagerRequestAudioFocusResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final AudioFocusManager.RequestAudioFocusResponse mCallback;

        AudioFocusManagerRequestAudioFocusResponseParamsForwardToCallback(AudioFocusManager.RequestAudioFocusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_AUDIO_FOCUS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                AudioFocusManagerRequestAudioFocusResponseParams response = AudioFocusManagerRequestAudioFocusResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.requestId);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class AudioFocusManagerRequestAudioFocusResponseParamsProxyToResponder implements AudioFocusManager.RequestAudioFocusResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        AudioFocusManagerRequestAudioFocusResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.UnguessableToken requestId) {
            AudioFocusManagerRequestAudioFocusResponseParams _response = new AudioFocusManagerRequestAudioFocusResponseParams();

            _response.requestId = requestId;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_AUDIO_FOCUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class AudioFocusManagerRequestGroupedAudioFocusParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<AudioFocusRequestClient> client;
        public MediaSession mediaSession;
        public MediaSessionInfo sessionInfo;
        public int type;
        public com.vccorp.mojo_base.mojom.UnguessableToken groupId;

        private AudioFocusManagerRequestGroupedAudioFocusParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerRequestGroupedAudioFocusParams() {
            this(0);
        }

        public static AudioFocusManagerRequestGroupedAudioFocusParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerRequestGroupedAudioFocusParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerRequestGroupedAudioFocusParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerRequestGroupedAudioFocusParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerRequestGroupedAudioFocusParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.mediaSession = decoder0.readServiceInterface(12, false, MediaSession.MANAGER);
                    }
                    {
                        
                    result.type = decoder0.readInt(20);
                        AudioFocusType.validate(result.type);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.sessionInfo = MediaSessionInfo.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.groupId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false);
            
            encoder0.encode(this.mediaSession, 12, false, MediaSession.MANAGER);
            
            encoder0.encode(this.type, 20);
            
            encoder0.encode(this.sessionInfo, 24, false);
            
            encoder0.encode(this.groupId, 32, false);
        }
    }



    
    static final class AudioFocusManagerRequestGroupedAudioFocusResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken requestId;

        private AudioFocusManagerRequestGroupedAudioFocusResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerRequestGroupedAudioFocusResponseParams() {
            this(0);
        }

        public static AudioFocusManagerRequestGroupedAudioFocusResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerRequestGroupedAudioFocusResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerRequestGroupedAudioFocusResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerRequestGroupedAudioFocusResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerRequestGroupedAudioFocusResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.requestId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestId, 8, false);
        }
    }

    static class AudioFocusManagerRequestGroupedAudioFocusResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final AudioFocusManager.RequestGroupedAudioFocusResponse mCallback;

        AudioFocusManagerRequestGroupedAudioFocusResponseParamsForwardToCallback(AudioFocusManager.RequestGroupedAudioFocusResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REQUEST_GROUPED_AUDIO_FOCUS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                AudioFocusManagerRequestGroupedAudioFocusResponseParams response = AudioFocusManagerRequestGroupedAudioFocusResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.requestId);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class AudioFocusManagerRequestGroupedAudioFocusResponseParamsProxyToResponder implements AudioFocusManager.RequestGroupedAudioFocusResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        AudioFocusManagerRequestGroupedAudioFocusResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.UnguessableToken requestId) {
            AudioFocusManagerRequestGroupedAudioFocusResponseParams _response = new AudioFocusManagerRequestGroupedAudioFocusResponseParams();

            _response.requestId = requestId;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REQUEST_GROUPED_AUDIO_FOCUS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class AudioFocusManagerGetFocusRequestsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private AudioFocusManagerGetFocusRequestsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerGetFocusRequestsParams() {
            this(0);
        }

        public static AudioFocusManagerGetFocusRequestsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerGetFocusRequestsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerGetFocusRequestsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerGetFocusRequestsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerGetFocusRequestsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class AudioFocusManagerGetFocusRequestsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioFocusRequestState[] requests;

        private AudioFocusManagerGetFocusRequestsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerGetFocusRequestsResponseParams() {
            this(0);
        }

        public static AudioFocusManagerGetFocusRequestsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerGetFocusRequestsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerGetFocusRequestsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerGetFocusRequestsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerGetFocusRequestsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.requests = new AudioFocusRequestState[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.requests[i1] = AudioFocusRequestState.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.requests == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.requests.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.requests.length; ++i0) {
                    
                    encoder1.encode(this.requests[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class AudioFocusManagerGetFocusRequestsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final AudioFocusManager.GetFocusRequestsResponse mCallback;

        AudioFocusManagerGetFocusRequestsResponseParamsForwardToCallback(AudioFocusManager.GetFocusRequestsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_FOCUS_REQUESTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                AudioFocusManagerGetFocusRequestsResponseParams response = AudioFocusManagerGetFocusRequestsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.requests);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class AudioFocusManagerGetFocusRequestsResponseParamsProxyToResponder implements AudioFocusManager.GetFocusRequestsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        AudioFocusManagerGetFocusRequestsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(AudioFocusRequestState[] requests) {
            AudioFocusManagerGetFocusRequestsResponseParams _response = new AudioFocusManagerGetFocusRequestsResponseParams();

            _response.requests = requests;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_FOCUS_REQUESTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class AudioFocusManagerAddObserverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioFocusObserver observer;

        private AudioFocusManagerAddObserverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerAddObserverParams() {
            this(0);
        }

        public static AudioFocusManagerAddObserverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerAddObserverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerAddObserverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerAddObserverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerAddObserverParams(elementsOrVersion);
                    {
                        
                    result.observer = decoder0.readServiceInterface(8, false, AudioFocusObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.observer, 8, false, AudioFocusObserver.MANAGER);
        }
    }



    
    static final class AudioFocusManagerSetSourceNameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String name;

        private AudioFocusManagerSetSourceNameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerSetSourceNameParams() {
            this(0);
        }

        public static AudioFocusManagerSetSourceNameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerSetSourceNameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerSetSourceNameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerSetSourceNameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerSetSourceNameParams(elementsOrVersion);
                    {
                        
                    result.name = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.name, 8, false);
        }
    }



    
    static final class AudioFocusManagerSetEnforcementModeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int mode;

        private AudioFocusManagerSetEnforcementModeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioFocusManagerSetEnforcementModeParams() {
            this(0);
        }

        public static AudioFocusManagerSetEnforcementModeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioFocusManagerSetEnforcementModeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioFocusManagerSetEnforcementModeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioFocusManagerSetEnforcementModeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioFocusManagerSetEnforcementModeParams(elementsOrVersion);
                    {
                        
                    result.mode = decoder0.readInt(8);
                        EnforcementMode.validate(result.mode);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.mode, 8);
        }
    }



}
