
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/watch_time_recorder.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WatchTimeRecorder_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WatchTimeRecorder, WatchTimeRecorder.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WatchTimeRecorder, WatchTimeRecorder.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.WatchTimeRecorder";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WatchTimeRecorder impl) {
            return new Stub(core, impl);
        }

        @Override
        public WatchTimeRecorder[] buildArray(int size) {
          return new WatchTimeRecorder[size];
        }
    };


    private static final int RECORD_WATCH_TIME_ORDINAL = 0;

    private static final int FINALIZE_WATCH_TIME_ORDINAL = 1;

    private static final int ON_ERROR_ORDINAL = 2;

    private static final int UPDATE_SECONDARY_PROPERTIES_ORDINAL = 3;

    private static final int SET_AUTOPLAY_INITIATED_ORDINAL = 4;

    private static final int ON_DURATION_CHANGED_ORDINAL = 5;

    private static final int UPDATE_UNDERFLOW_COUNT_ORDINAL = 6;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WatchTimeRecorder.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void recordWatchTime(
int key, com.vccorp.mojo_base.mojom.TimeDelta watchTime) {

            WatchTimeRecorderRecordWatchTimeParams _message = new WatchTimeRecorderRecordWatchTimeParams();

            _message.key = key;

            _message.watchTime = watchTime;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RECORD_WATCH_TIME_ORDINAL)));

        }


        @Override
        public void finalizeWatchTime(
int[] watchTimeKeys) {

            WatchTimeRecorderFinalizeWatchTimeParams _message = new WatchTimeRecorderFinalizeWatchTimeParams();

            _message.watchTimeKeys = watchTimeKeys;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(FINALIZE_WATCH_TIME_ORDINAL)));

        }


        @Override
        public void onError(
int status) {

            WatchTimeRecorderOnErrorParams _message = new WatchTimeRecorderOnErrorParams();

            _message.status = status;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ERROR_ORDINAL)));

        }


        @Override
        public void updateSecondaryProperties(
SecondaryPlaybackProperties secondaryProperties) {

            WatchTimeRecorderUpdateSecondaryPropertiesParams _message = new WatchTimeRecorderUpdateSecondaryPropertiesParams();

            _message.secondaryProperties = secondaryProperties;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_SECONDARY_PROPERTIES_ORDINAL)));

        }


        @Override
        public void setAutoplayInitiated(
boolean value) {

            WatchTimeRecorderSetAutoplayInitiatedParams _message = new WatchTimeRecorderSetAutoplayInitiatedParams();

            _message.value = value;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_AUTOPLAY_INITIATED_ORDINAL)));

        }


        @Override
        public void onDurationChanged(
com.vccorp.mojo_base.mojom.TimeDelta duration) {

            WatchTimeRecorderOnDurationChangedParams _message = new WatchTimeRecorderOnDurationChangedParams();

            _message.duration = duration;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_DURATION_CHANGED_ORDINAL)));

        }


        @Override
        public void updateUnderflowCount(
int count) {

            WatchTimeRecorderUpdateUnderflowCountParams _message = new WatchTimeRecorderUpdateUnderflowCountParams();

            _message.count = count;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_UNDERFLOW_COUNT_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WatchTimeRecorder> {

        Stub(com.vccorp.mojo.system.Core core, WatchTimeRecorder impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WatchTimeRecorder_Internal.MANAGER, messageWithHeader);





                    case RECORD_WATCH_TIME_ORDINAL: {

                        WatchTimeRecorderRecordWatchTimeParams data =
                                WatchTimeRecorderRecordWatchTimeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().recordWatchTime(data.key, data.watchTime);
                        return true;
                    }





                    case FINALIZE_WATCH_TIME_ORDINAL: {

                        WatchTimeRecorderFinalizeWatchTimeParams data =
                                WatchTimeRecorderFinalizeWatchTimeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().finalizeWatchTime(data.watchTimeKeys);
                        return true;
                    }





                    case ON_ERROR_ORDINAL: {

                        WatchTimeRecorderOnErrorParams data =
                                WatchTimeRecorderOnErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onError(data.status);
                        return true;
                    }





                    case UPDATE_SECONDARY_PROPERTIES_ORDINAL: {

                        WatchTimeRecorderUpdateSecondaryPropertiesParams data =
                                WatchTimeRecorderUpdateSecondaryPropertiesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateSecondaryProperties(data.secondaryProperties);
                        return true;
                    }





                    case SET_AUTOPLAY_INITIATED_ORDINAL: {

                        WatchTimeRecorderSetAutoplayInitiatedParams data =
                                WatchTimeRecorderSetAutoplayInitiatedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setAutoplayInitiated(data.value);
                        return true;
                    }





                    case ON_DURATION_CHANGED_ORDINAL: {

                        WatchTimeRecorderOnDurationChangedParams data =
                                WatchTimeRecorderOnDurationChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onDurationChanged(data.duration);
                        return true;
                    }





                    case UPDATE_UNDERFLOW_COUNT_ORDINAL: {

                        WatchTimeRecorderUpdateUnderflowCountParams data =
                                WatchTimeRecorderUpdateUnderflowCountParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateUnderflowCount(data.count);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WatchTimeRecorder_Internal.MANAGER, messageWithHeader, receiver);
















                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WatchTimeRecorderRecordWatchTimeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int key;
        public com.vccorp.mojo_base.mojom.TimeDelta watchTime;

        private WatchTimeRecorderRecordWatchTimeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderRecordWatchTimeParams() {
            this(0);
        }

        public static WatchTimeRecorderRecordWatchTimeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderRecordWatchTimeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderRecordWatchTimeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderRecordWatchTimeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderRecordWatchTimeParams(elementsOrVersion);
                    {
                        
                    result.key = decoder0.readInt(8);
                        WatchTimeKey.validate(result.key);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.watchTime = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.key, 8);
            
            encoder0.encode(this.watchTime, 16, false);
        }
    }



    
    static final class WatchTimeRecorderFinalizeWatchTimeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int[] watchTimeKeys;

        private WatchTimeRecorderFinalizeWatchTimeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderFinalizeWatchTimeParams() {
            this(0);
        }

        public static WatchTimeRecorderFinalizeWatchTimeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderFinalizeWatchTimeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderFinalizeWatchTimeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderFinalizeWatchTimeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderFinalizeWatchTimeParams(elementsOrVersion);
                    {
                        
                    result.watchTimeKeys = decoder0.readInts(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    {
                        for (int i0 = 0; i0 < result.watchTimeKeys.length; ++i0) {
                            WatchTimeKey.validate(result.watchTimeKeys[i0]);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.watchTimeKeys, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class WatchTimeRecorderOnErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int status;

        private WatchTimeRecorderOnErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderOnErrorParams() {
            this(0);
        }

        public static WatchTimeRecorderOnErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderOnErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderOnErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderOnErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderOnErrorParams(elementsOrVersion);
                    {
                        
                    result.status = decoder0.readInt(8);
                        PipelineStatus.validate(result.status);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.status, 8);
        }
    }



    
    static final class WatchTimeRecorderUpdateSecondaryPropertiesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SecondaryPlaybackProperties secondaryProperties;

        private WatchTimeRecorderUpdateSecondaryPropertiesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderUpdateSecondaryPropertiesParams() {
            this(0);
        }

        public static WatchTimeRecorderUpdateSecondaryPropertiesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderUpdateSecondaryPropertiesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderUpdateSecondaryPropertiesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderUpdateSecondaryPropertiesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderUpdateSecondaryPropertiesParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.secondaryProperties = SecondaryPlaybackProperties.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.secondaryProperties, 8, false);
        }
    }



    
    static final class WatchTimeRecorderSetAutoplayInitiatedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean value;

        private WatchTimeRecorderSetAutoplayInitiatedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderSetAutoplayInitiatedParams() {
            this(0);
        }

        public static WatchTimeRecorderSetAutoplayInitiatedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderSetAutoplayInitiatedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderSetAutoplayInitiatedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderSetAutoplayInitiatedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderSetAutoplayInitiatedParams(elementsOrVersion);
                    {
                        
                    result.value = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.value, 8, 0);
        }
    }



    
    static final class WatchTimeRecorderOnDurationChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta duration;

        private WatchTimeRecorderOnDurationChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderOnDurationChangedParams() {
            this(0);
        }

        public static WatchTimeRecorderOnDurationChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderOnDurationChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderOnDurationChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderOnDurationChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderOnDurationChangedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.duration = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.duration, 8, false);
        }
    }



    
    static final class WatchTimeRecorderUpdateUnderflowCountParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int count;

        private WatchTimeRecorderUpdateUnderflowCountParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WatchTimeRecorderUpdateUnderflowCountParams() {
            this(0);
        }

        public static WatchTimeRecorderUpdateUnderflowCountParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WatchTimeRecorderUpdateUnderflowCountParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WatchTimeRecorderUpdateUnderflowCountParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WatchTimeRecorderUpdateUnderflowCountParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WatchTimeRecorderUpdateUnderflowCountParams(elementsOrVersion);
                    {
                        
                    result.count = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.count, 8);
        }
    }



}
