
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class VideoFrameData extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int EosData = 0;
        public static final int SharedBufferData = 1;
        public static final int MailboxData = 2;
    };
    private EosVideoFrameData mEosData;
    private SharedBufferVideoFrameData mSharedBufferData;
    private MailboxVideoFrameData mMailboxData;

    public void setEosData(EosVideoFrameData eosData) {
        this.mTag = Tag.EosData;
        this.mEosData = eosData;
    }

    public EosVideoFrameData getEosData() {
        assert this.mTag == Tag.EosData;
        return this.mEosData;
    }

    public void setSharedBufferData(SharedBufferVideoFrameData sharedBufferData) {
        this.mTag = Tag.SharedBufferData;
        this.mSharedBufferData = sharedBufferData;
    }

    public SharedBufferVideoFrameData getSharedBufferData() {
        assert this.mTag == Tag.SharedBufferData;
        return this.mSharedBufferData;
    }

    public void setMailboxData(MailboxVideoFrameData mailboxData) {
        this.mTag = Tag.MailboxData;
        this.mMailboxData = mailboxData;
    }

    public MailboxVideoFrameData getMailboxData() {
        assert this.mTag == Tag.MailboxData;
        return this.mMailboxData;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.EosData: {
                
                encoder0.encode(this.mEosData, offset + 8, false);
                break;
            }
            case Tag.SharedBufferData: {
                
                encoder0.encode(this.mSharedBufferData, offset + 8, false);
                break;
            }
            case Tag.MailboxData: {
                
                encoder0.encode(this.mMailboxData, offset + 8, false);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static VideoFrameData deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final VideoFrameData decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        VideoFrameData result = new VideoFrameData();
        switch (dataHeader.elementsOrVersion) {
            case Tag.EosData: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mEosData = EosVideoFrameData.decode(decoder1);
                result.mTag = Tag.EosData;
                break;
            }
            case Tag.SharedBufferData: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mSharedBufferData = SharedBufferVideoFrameData.decode(decoder1);
                result.mTag = Tag.SharedBufferData;
                break;
            }
            case Tag.MailboxData: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mMailboxData = MailboxVideoFrameData.decode(decoder1);
                result.mTag = Tag.MailboxData;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}