
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class VideoFrame extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int format;
    public com.vccorp.gfx.mojom.Size codedSize;
    public com.vccorp.gfx.mojom.Rect visibleRect;
    public com.vccorp.gfx.mojom.Size naturalSize;
    public com.vccorp.mojo_base.mojom.TimeDelta timestamp;
    public VideoFrameData data;
    public com.vccorp.mojo_base.mojom.DictionaryValue metadata;
    public com.vccorp.gfx.mojom.ColorSpace colorSpace;

    private VideoFrame(int version) {
        super(STRUCT_SIZE, version);
    }

    public VideoFrame() {
        this(0);
    }

    public static VideoFrame deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static VideoFrame deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static VideoFrame decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        VideoFrame result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new VideoFrame(elementsOrVersion);
                {
                    
                result.format = decoder0.readInt(8);
                    VideoPixelFormat.validate(result.format);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.codedSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.visibleRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.naturalSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.timestamp = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.data = VideoFrameData.decode(decoder0, 48);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.metadata = com.vccorp.mojo_base.mojom.DictionaryValue.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, false);
                result.colorSpace = com.vccorp.gfx.mojom.ColorSpace.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.format, 8);
        
        encoder0.encode(this.codedSize, 16, false);
        
        encoder0.encode(this.visibleRect, 24, false);
        
        encoder0.encode(this.naturalSize, 32, false);
        
        encoder0.encode(this.timestamp, 40, false);
        
        encoder0.encode(this.data, 48, false);
        
        encoder0.encode(this.metadata, 64, false);
        
        encoder0.encode(this.colorSpace, 72, false);
    }
}