
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_encode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface VideoEncodeAccelerator extends com.vccorp.mojo.bindings.Interface {



    public static final class Error {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int ILLEGAL_STATE = 0;
        public static final int INVALID_ARGUMENT = 1; // ILLEGAL_STATE + 1
        public static final int PLATFORM_FAILURE = 2; // INVALID_ARGUMENT + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 2;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private Error() {}
    }


    public interface Proxy extends VideoEncodeAccelerator, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<VideoEncodeAccelerator, VideoEncodeAccelerator.Proxy> MANAGER = VideoEncodeAccelerator_Internal.MANAGER;


    void initialize(
VideoEncodeAcceleratorConfig config, VideoEncodeAcceleratorClient client, 
InitializeResponse callback);

    interface InitializeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }



    void encode(
VideoFrame frame, boolean forceKeyframe, 
EncodeResponse callback);

    interface EncodeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback0 { }



    void useOutputBitstreamBuffer(
int bitstreamBufferId, com.vccorp.mojo.system.SharedBufferHandle buffer);



    void requestEncodingParametersChange(
VideoBitrateAllocation bitrateAllocation, int framerate);


}
