
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;


import org.chromium.media.mojom.HdrMetadata;


public final class VideoDecoderConfig extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 80;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(80, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int codec;
    public int profile;
    public int format;
    public int videoRotation;
    public com.vccorp.gfx.mojom.Size codedSize;
    public com.vccorp.gfx.mojom.Rect visibleRect;
    public com.vccorp.gfx.mojom.Size naturalSize;
    public byte[] extraData;
    public EncryptionScheme encryptionScheme;
    public VideoColorSpace colorSpaceInfo;
    public HdrMetadata hdrMetadata;

    private VideoDecoderConfig(int version) {
        super(STRUCT_SIZE, version);
    }

    public VideoDecoderConfig() {
        this(0);
    }

    public static VideoDecoderConfig deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static VideoDecoderConfig deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static VideoDecoderConfig decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        VideoDecoderConfig result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new VideoDecoderConfig(elementsOrVersion);
                {
                    
                result.codec = decoder0.readInt(8);
                    VideoCodec.validate(result.codec);
                }
                {
                    
                result.profile = decoder0.readInt(12);
                    VideoCodecProfile.validate(result.profile);
                }
                {
                    
                result.format = decoder0.readInt(16);
                    VideoPixelFormat.validate(result.format);
                }
                {
                    
                result.videoRotation = decoder0.readInt(20);
                    VideoRotation.validate(result.videoRotation);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.codedSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.visibleRect = com.vccorp.gfx.mojom.Rect.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.naturalSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.extraData = decoder0.readBytes(48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.encryptionScheme = EncryptionScheme.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, false);
                result.colorSpaceInfo = VideoColorSpace.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(72, true);
                result.hdrMetadata = HdrMetadata.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.codec, 8);
        
        encoder0.encode(this.profile, 12);
        
        encoder0.encode(this.format, 16);
        
        encoder0.encode(this.videoRotation, 20);
        
        encoder0.encode(this.codedSize, 24, false);
        
        encoder0.encode(this.visibleRect, 32, false);
        
        encoder0.encode(this.naturalSize, 40, false);
        
        encoder0.encode(this.extraData, 48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.encryptionScheme, 56, false);
        
        encoder0.encode(this.colorSpaceInfo, 64, false);
        
        encoder0.encode(this.hdrMetadata, 72, true);
    }
}