
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_decoder.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoDecoderClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoDecoderClient, VideoDecoderClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoDecoderClient, VideoDecoderClient.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.VideoDecoderClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoDecoderClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoDecoderClient[] buildArray(int size) {
          return new VideoDecoderClient[size];
        }
    };


    private static final int ON_VIDEO_FRAME_DECODED_ORDINAL = 0;

    private static final int ON_WAITING_ORDINAL = 1;

    private static final int REQUEST_OVERLAY_INFO_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoDecoderClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onVideoFrameDecoded(
VideoFrame frame, boolean canReadWithoutStalling, com.vccorp.mojo_base.mojom.UnguessableToken releaseToken) {

            VideoDecoderClientOnVideoFrameDecodedParams _message = new VideoDecoderClientOnVideoFrameDecodedParams();

            _message.frame = frame;

            _message.canReadWithoutStalling = canReadWithoutStalling;

            _message.releaseToken = releaseToken;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_FRAME_DECODED_ORDINAL)));

        }


        @Override
        public void onWaiting(
int reason) {

            VideoDecoderClientOnWaitingParams _message = new VideoDecoderClientOnWaitingParams();

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_WAITING_ORDINAL)));

        }


        @Override
        public void requestOverlayInfo(
boolean restartForTransitions) {

            VideoDecoderClientRequestOverlayInfoParams _message = new VideoDecoderClientRequestOverlayInfoParams();

            _message.restartForTransitions = restartForTransitions;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REQUEST_OVERLAY_INFO_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoDecoderClient> {

        Stub(com.vccorp.mojo.system.Core core, VideoDecoderClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoDecoderClient_Internal.MANAGER, messageWithHeader);





                    case ON_VIDEO_FRAME_DECODED_ORDINAL: {

                        VideoDecoderClientOnVideoFrameDecodedParams data =
                                VideoDecoderClientOnVideoFrameDecodedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoFrameDecoded(data.frame, data.canReadWithoutStalling, data.releaseToken);
                        return true;
                    }





                    case ON_WAITING_ORDINAL: {

                        VideoDecoderClientOnWaitingParams data =
                                VideoDecoderClientOnWaitingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onWaiting(data.reason);
                        return true;
                    }





                    case REQUEST_OVERLAY_INFO_ORDINAL: {

                        VideoDecoderClientRequestOverlayInfoParams data =
                                VideoDecoderClientRequestOverlayInfoParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestOverlayInfo(data.restartForTransitions);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoDecoderClient_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoDecoderClientOnVideoFrameDecodedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoFrame frame;
        public boolean canReadWithoutStalling;
        public com.vccorp.mojo_base.mojom.UnguessableToken releaseToken;

        private VideoDecoderClientOnVideoFrameDecodedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDecoderClientOnVideoFrameDecodedParams() {
            this(0);
        }

        public static VideoDecoderClientOnVideoFrameDecodedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDecoderClientOnVideoFrameDecodedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDecoderClientOnVideoFrameDecodedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDecoderClientOnVideoFrameDecodedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDecoderClientOnVideoFrameDecodedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.frame = VideoFrame.decode(decoder1);
                    }
                    {
                        
                    result.canReadWithoutStalling = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.releaseToken = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.frame, 8, false);
            
            encoder0.encode(this.canReadWithoutStalling, 16, 0);
            
            encoder0.encode(this.releaseToken, 24, true);
        }
    }



    
    static final class VideoDecoderClientOnWaitingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int reason;

        private VideoDecoderClientOnWaitingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDecoderClientOnWaitingParams() {
            this(0);
        }

        public static VideoDecoderClientOnWaitingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDecoderClientOnWaitingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDecoderClientOnWaitingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDecoderClientOnWaitingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDecoderClientOnWaitingParams(elementsOrVersion);
                    {
                        
                    result.reason = decoder0.readInt(8);
                        WaitingReason.validate(result.reason);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reason, 8);
        }
    }



    
    static final class VideoDecoderClientRequestOverlayInfoParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean restartForTransitions;

        private VideoDecoderClientRequestOverlayInfoParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoDecoderClientRequestOverlayInfoParams() {
            this(0);
        }

        public static VideoDecoderClientRequestOverlayInfoParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoDecoderClientRequestOverlayInfoParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoDecoderClientRequestOverlayInfoParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoDecoderClientRequestOverlayInfoParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoDecoderClientRequestOverlayInfoParams(elementsOrVersion);
                    {
                        
                    result.restartForTransitions = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.restartForTransitions, 8, 0);
        }
    }



}
