
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VideoCaptureHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VideoCaptureHost, VideoCaptureHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VideoCaptureHost, VideoCaptureHost.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.VideoCaptureHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VideoCaptureHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public VideoCaptureHost[] buildArray(int size) {
          return new VideoCaptureHost[size];
        }
    };


    private static final int START_ORDINAL = 0;

    private static final int STOP_ORDINAL = 1;

    private static final int PAUSE_ORDINAL = 2;

    private static final int RESUME_ORDINAL = 3;

    private static final int REQUEST_REFRESH_FRAME_ORDINAL = 4;

    private static final int RELEASE_BUFFER_ORDINAL = 5;

    private static final int GET_DEVICE_SUPPORTED_FORMATS_ORDINAL = 6;

    private static final int GET_DEVICE_FORMATS_IN_USE_ORDINAL = 7;

    private static final int ON_FRAME_DROPPED_ORDINAL = 8;

    private static final int ON_LOG_ORDINAL = 9;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VideoCaptureHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void start(
int deviceId, int sessionId, VideoCaptureParams params, VideoCaptureObserver observer) {

            VideoCaptureHostStartParams _message = new VideoCaptureHostStartParams();

            _message.deviceId = deviceId;

            _message.sessionId = sessionId;

            _message.params = params;

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_ORDINAL)));

        }


        @Override
        public void stop(
int deviceId) {

            VideoCaptureHostStopParams _message = new VideoCaptureHostStopParams();

            _message.deviceId = deviceId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(STOP_ORDINAL)));

        }


        @Override
        public void pause(
int deviceId) {

            VideoCaptureHostPauseParams _message = new VideoCaptureHostPauseParams();

            _message.deviceId = deviceId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(PAUSE_ORDINAL)));

        }


        @Override
        public void resume(
int deviceId, int sessionId, VideoCaptureParams params) {

            VideoCaptureHostResumeParams _message = new VideoCaptureHostResumeParams();

            _message.deviceId = deviceId;

            _message.sessionId = sessionId;

            _message.params = params;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESUME_ORDINAL)));

        }


        @Override
        public void requestRefreshFrame(
int deviceId) {

            VideoCaptureHostRequestRefreshFrameParams _message = new VideoCaptureHostRequestRefreshFrameParams();

            _message.deviceId = deviceId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REQUEST_REFRESH_FRAME_ORDINAL)));

        }


        @Override
        public void releaseBuffer(
int deviceId, int bufferId, double consumerResourceUtilization) {

            VideoCaptureHostReleaseBufferParams _message = new VideoCaptureHostReleaseBufferParams();

            _message.deviceId = deviceId;

            _message.bufferId = bufferId;

            _message.consumerResourceUtilization = consumerResourceUtilization;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RELEASE_BUFFER_ORDINAL)));

        }


        @Override
        public void getDeviceSupportedFormats(
int deviceId, int sessionId, 
GetDeviceSupportedFormatsResponse callback) {

            VideoCaptureHostGetDeviceSupportedFormatsParams _message = new VideoCaptureHostGetDeviceSupportedFormatsParams();

            _message.deviceId = deviceId;

            _message.sessionId = sessionId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVICE_SUPPORTED_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VideoCaptureHostGetDeviceSupportedFormatsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getDeviceFormatsInUse(
int deviceId, int sessionId, 
GetDeviceFormatsInUseResponse callback) {

            VideoCaptureHostGetDeviceFormatsInUseParams _message = new VideoCaptureHostGetDeviceFormatsInUseParams();

            _message.deviceId = deviceId;

            _message.sessionId = sessionId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVICE_FORMATS_IN_USE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VideoCaptureHostGetDeviceFormatsInUseResponseParamsForwardToCallback(callback));

        }


        @Override
        public void onFrameDropped(
int deviceId, int reason) {

            VideoCaptureHostOnFrameDroppedParams _message = new VideoCaptureHostOnFrameDroppedParams();

            _message.deviceId = deviceId;

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_FRAME_DROPPED_ORDINAL)));

        }


        @Override
        public void onLog(
int deviceId, String message) {

            VideoCaptureHostOnLogParams _message = new VideoCaptureHostOnLogParams();

            _message.deviceId = deviceId;

            _message.message = message;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_LOG_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VideoCaptureHost> {

        Stub(com.vccorp.mojo.system.Core core, VideoCaptureHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VideoCaptureHost_Internal.MANAGER, messageWithHeader);





                    case START_ORDINAL: {

                        VideoCaptureHostStartParams data =
                                VideoCaptureHostStartParams.deserialize(messageWithHeader.getPayload());

                        getImpl().start(data.deviceId, data.sessionId, data.params, data.observer);
                        return true;
                    }





                    case STOP_ORDINAL: {

                        VideoCaptureHostStopParams data =
                                VideoCaptureHostStopParams.deserialize(messageWithHeader.getPayload());

                        getImpl().stop(data.deviceId);
                        return true;
                    }





                    case PAUSE_ORDINAL: {

                        VideoCaptureHostPauseParams data =
                                VideoCaptureHostPauseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().pause(data.deviceId);
                        return true;
                    }





                    case RESUME_ORDINAL: {

                        VideoCaptureHostResumeParams data =
                                VideoCaptureHostResumeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resume(data.deviceId, data.sessionId, data.params);
                        return true;
                    }





                    case REQUEST_REFRESH_FRAME_ORDINAL: {

                        VideoCaptureHostRequestRefreshFrameParams data =
                                VideoCaptureHostRequestRefreshFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().requestRefreshFrame(data.deviceId);
                        return true;
                    }





                    case RELEASE_BUFFER_ORDINAL: {

                        VideoCaptureHostReleaseBufferParams data =
                                VideoCaptureHostReleaseBufferParams.deserialize(messageWithHeader.getPayload());

                        getImpl().releaseBuffer(data.deviceId, data.bufferId, data.consumerResourceUtilization);
                        return true;
                    }









                    case ON_FRAME_DROPPED_ORDINAL: {

                        VideoCaptureHostOnFrameDroppedParams data =
                                VideoCaptureHostOnFrameDroppedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onFrameDropped(data.deviceId, data.reason);
                        return true;
                    }





                    case ON_LOG_ORDINAL: {

                        VideoCaptureHostOnLogParams data =
                                VideoCaptureHostOnLogParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onLog(data.deviceId, data.message);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VideoCaptureHost_Internal.MANAGER, messageWithHeader, receiver);



















                    case GET_DEVICE_SUPPORTED_FORMATS_ORDINAL: {

                        VideoCaptureHostGetDeviceSupportedFormatsParams data =
                                VideoCaptureHostGetDeviceSupportedFormatsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getDeviceSupportedFormats(data.deviceId, data.sessionId, new VideoCaptureHostGetDeviceSupportedFormatsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_DEVICE_FORMATS_IN_USE_ORDINAL: {

                        VideoCaptureHostGetDeviceFormatsInUseParams data =
                                VideoCaptureHostGetDeviceFormatsInUseParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getDeviceFormatsInUse(data.deviceId, data.sessionId, new VideoCaptureHostGetDeviceFormatsInUseResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VideoCaptureHostStartParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int sessionId;
        public VideoCaptureParams params;
        public VideoCaptureObserver observer;

        private VideoCaptureHostStartParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostStartParams() {
            this(0);
        }

        public static VideoCaptureHostStartParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostStartParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostStartParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostStartParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostStartParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.sessionId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.params = VideoCaptureParams.decode(decoder1);
                    }
                    {
                        
                    result.observer = decoder0.readServiceInterface(24, false, VideoCaptureObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.sessionId, 12);
            
            encoder0.encode(this.params, 16, false);
            
            encoder0.encode(this.observer, 24, false, VideoCaptureObserver.MANAGER);
        }
    }



    
    static final class VideoCaptureHostStopParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;

        private VideoCaptureHostStopParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostStopParams() {
            this(0);
        }

        public static VideoCaptureHostStopParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostStopParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostStopParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostStopParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostStopParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
        }
    }



    
    static final class VideoCaptureHostPauseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;

        private VideoCaptureHostPauseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostPauseParams() {
            this(0);
        }

        public static VideoCaptureHostPauseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostPauseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostPauseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostPauseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostPauseParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
        }
    }



    
    static final class VideoCaptureHostResumeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int sessionId;
        public VideoCaptureParams params;

        private VideoCaptureHostResumeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostResumeParams() {
            this(0);
        }

        public static VideoCaptureHostResumeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostResumeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostResumeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostResumeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostResumeParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.sessionId = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.params = VideoCaptureParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.sessionId, 12);
            
            encoder0.encode(this.params, 16, false);
        }
    }



    
    static final class VideoCaptureHostRequestRefreshFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;

        private VideoCaptureHostRequestRefreshFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostRequestRefreshFrameParams() {
            this(0);
        }

        public static VideoCaptureHostRequestRefreshFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostRequestRefreshFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostRequestRefreshFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostRequestRefreshFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostRequestRefreshFrameParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
        }
    }



    
    static final class VideoCaptureHostReleaseBufferParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int bufferId;
        public double consumerResourceUtilization;

        private VideoCaptureHostReleaseBufferParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostReleaseBufferParams() {
            this(0);
        }

        public static VideoCaptureHostReleaseBufferParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostReleaseBufferParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostReleaseBufferParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostReleaseBufferParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostReleaseBufferParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.bufferId = decoder0.readInt(12);
                    }
                    {
                        
                    result.consumerResourceUtilization = decoder0.readDouble(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.bufferId, 12);
            
            encoder0.encode(this.consumerResourceUtilization, 16);
        }
    }



    
    static final class VideoCaptureHostGetDeviceSupportedFormatsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int sessionId;

        private VideoCaptureHostGetDeviceSupportedFormatsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostGetDeviceSupportedFormatsParams() {
            this(0);
        }

        public static VideoCaptureHostGetDeviceSupportedFormatsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostGetDeviceSupportedFormatsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostGetDeviceSupportedFormatsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostGetDeviceSupportedFormatsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostGetDeviceSupportedFormatsParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.sessionId = decoder0.readInt(12);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.sessionId, 12);
        }
    }



    
    static final class VideoCaptureHostGetDeviceSupportedFormatsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoCaptureFormat[] formatsSupported;

        private VideoCaptureHostGetDeviceSupportedFormatsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostGetDeviceSupportedFormatsResponseParams() {
            this(0);
        }

        public static VideoCaptureHostGetDeviceSupportedFormatsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostGetDeviceSupportedFormatsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostGetDeviceSupportedFormatsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostGetDeviceSupportedFormatsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostGetDeviceSupportedFormatsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.formatsSupported = new VideoCaptureFormat[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.formatsSupported[i1] = VideoCaptureFormat.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.formatsSupported == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.formatsSupported.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.formatsSupported.length; ++i0) {
                    
                    encoder1.encode(this.formatsSupported[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class VideoCaptureHostGetDeviceSupportedFormatsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VideoCaptureHost.GetDeviceSupportedFormatsResponse mCallback;

        VideoCaptureHostGetDeviceSupportedFormatsResponseParamsForwardToCallback(VideoCaptureHost.GetDeviceSupportedFormatsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_DEVICE_SUPPORTED_FORMATS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VideoCaptureHostGetDeviceSupportedFormatsResponseParams response = VideoCaptureHostGetDeviceSupportedFormatsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.formatsSupported);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VideoCaptureHostGetDeviceSupportedFormatsResponseParamsProxyToResponder implements VideoCaptureHost.GetDeviceSupportedFormatsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VideoCaptureHostGetDeviceSupportedFormatsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(VideoCaptureFormat[] formatsSupported) {
            VideoCaptureHostGetDeviceSupportedFormatsResponseParams _response = new VideoCaptureHostGetDeviceSupportedFormatsResponseParams();

            _response.formatsSupported = formatsSupported;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVICE_SUPPORTED_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VideoCaptureHostGetDeviceFormatsInUseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int sessionId;

        private VideoCaptureHostGetDeviceFormatsInUseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostGetDeviceFormatsInUseParams() {
            this(0);
        }

        public static VideoCaptureHostGetDeviceFormatsInUseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostGetDeviceFormatsInUseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostGetDeviceFormatsInUseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostGetDeviceFormatsInUseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostGetDeviceFormatsInUseParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.sessionId = decoder0.readInt(12);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.sessionId, 12);
        }
    }



    
    static final class VideoCaptureHostGetDeviceFormatsInUseResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoCaptureFormat[] formatsInUse;

        private VideoCaptureHostGetDeviceFormatsInUseResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostGetDeviceFormatsInUseResponseParams() {
            this(0);
        }

        public static VideoCaptureHostGetDeviceFormatsInUseResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostGetDeviceFormatsInUseResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostGetDeviceFormatsInUseResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostGetDeviceFormatsInUseResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostGetDeviceFormatsInUseResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.formatsInUse = new VideoCaptureFormat[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.formatsInUse[i1] = VideoCaptureFormat.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.formatsInUse == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.formatsInUse.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.formatsInUse.length; ++i0) {
                    
                    encoder1.encode(this.formatsInUse[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class VideoCaptureHostGetDeviceFormatsInUseResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VideoCaptureHost.GetDeviceFormatsInUseResponse mCallback;

        VideoCaptureHostGetDeviceFormatsInUseResponseParamsForwardToCallback(VideoCaptureHost.GetDeviceFormatsInUseResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_DEVICE_FORMATS_IN_USE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VideoCaptureHostGetDeviceFormatsInUseResponseParams response = VideoCaptureHostGetDeviceFormatsInUseResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.formatsInUse);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VideoCaptureHostGetDeviceFormatsInUseResponseParamsProxyToResponder implements VideoCaptureHost.GetDeviceFormatsInUseResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VideoCaptureHostGetDeviceFormatsInUseResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(VideoCaptureFormat[] formatsInUse) {
            VideoCaptureHostGetDeviceFormatsInUseResponseParams _response = new VideoCaptureHostGetDeviceFormatsInUseResponseParams();

            _response.formatsInUse = formatsInUse;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DEVICE_FORMATS_IN_USE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VideoCaptureHostOnFrameDroppedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public int reason;

        private VideoCaptureHostOnFrameDroppedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostOnFrameDroppedParams() {
            this(0);
        }

        public static VideoCaptureHostOnFrameDroppedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostOnFrameDroppedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostOnFrameDroppedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostOnFrameDroppedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostOnFrameDroppedParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.reason = decoder0.readInt(12);
                        VideoCaptureFrameDropReason.validate(result.reason);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.reason, 12);
        }
    }



    
    static final class VideoCaptureHostOnLogParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int deviceId;
        public String message;

        private VideoCaptureHostOnLogParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VideoCaptureHostOnLogParams() {
            this(0);
        }

        public static VideoCaptureHostOnLogParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VideoCaptureHostOnLogParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VideoCaptureHostOnLogParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VideoCaptureHostOnLogParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VideoCaptureHostOnLogParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readInt(8);
                    }
                    {
                        
                    result.message = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8);
            
            encoder0.encode(this.message, 16, false);
        }
    }



}
