
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface VideoCaptureHost extends com.vccorp.mojo.bindings.Interface {



    public interface Proxy extends VideoCaptureHost, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<VideoCaptureHost, VideoCaptureHost.Proxy> MANAGER = VideoCaptureHost_Internal.MANAGER;


    void start(
int deviceId, int sessionId, VideoCaptureParams params, VideoCaptureObserver observer);



    void stop(
int deviceId);



    void pause(
int deviceId);



    void resume(
int deviceId, int sessionId, VideoCaptureParams params);



    void requestRefreshFrame(
int deviceId);



    void releaseBuffer(
int deviceId, int bufferId, double consumerResourceUtilization);



    void getDeviceSupportedFormats(
int deviceId, int sessionId, 
GetDeviceSupportedFormatsResponse callback);

    interface GetDeviceSupportedFormatsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<VideoCaptureFormat[]> { }



    void getDeviceFormatsInUse(
int deviceId, int sessionId, 
GetDeviceFormatsInUseResponse callback);

    interface GetDeviceFormatsInUseResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<VideoCaptureFormat[]> { }



    void onFrameDropped(
int deviceId, int reason);



    void onLog(
int deviceId, String message);


}
