
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class VideoCaptureDeviceDescriptor extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String displayName;
    public String deviceId;
    public String modelId;
    public int facingMode;
    public int captureApi;
    public int transportType;

    private VideoCaptureDeviceDescriptor(int version) {
        super(STRUCT_SIZE, version);
    }

    public VideoCaptureDeviceDescriptor() {
        this(0);
    }

    public static VideoCaptureDeviceDescriptor deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static VideoCaptureDeviceDescriptor deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static VideoCaptureDeviceDescriptor decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        VideoCaptureDeviceDescriptor result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new VideoCaptureDeviceDescriptor(elementsOrVersion);
                {
                    
                result.displayName = decoder0.readString(8, false);
                }
                {
                    
                result.deviceId = decoder0.readString(16, false);
                }
                {
                    
                result.modelId = decoder0.readString(24, false);
                }
                {
                    
                result.facingMode = decoder0.readInt(32);
                    VideoFacingMode.validate(result.facingMode);
                }
                {
                    
                result.captureApi = decoder0.readInt(36);
                    VideoCaptureApi.validate(result.captureApi);
                }
                {
                    
                result.transportType = decoder0.readInt(40);
                    VideoCaptureTransportType.validate(result.transportType);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.displayName, 8, false);
        
        encoder0.encode(this.deviceId, 16, false);
        
        encoder0.encode(this.modelId, 24, false);
        
        encoder0.encode(this.facingMode, 32);
        
        encoder0.encode(this.captureApi, 36);
        
        encoder0.encode(this.transportType, 40);
    }
}