
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SharedBufferVideoFrameData extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.mojo.system.SharedBufferHandle frameData;
    public long frameDataSize;
    public int yStride;
    public int uStride;
    public int vStride;
    public long yOffset;
    public long uOffset;
    public long vOffset;

    private SharedBufferVideoFrameData(int version) {
        super(STRUCT_SIZE, version);
        this.frameData = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
    }

    public SharedBufferVideoFrameData() {
        this(0);
    }

    public static SharedBufferVideoFrameData deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SharedBufferVideoFrameData deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SharedBufferVideoFrameData decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SharedBufferVideoFrameData result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SharedBufferVideoFrameData(elementsOrVersion);
                {
                    
                result.frameData = decoder0.readSharedBufferHandle(8, false);
                }
                {
                    
                result.yStride = decoder0.readInt(12);
                }
                {
                    
                result.frameDataSize = decoder0.readLong(16);
                }
                {
                    
                result.uStride = decoder0.readInt(24);
                }
                {
                    
                result.vStride = decoder0.readInt(28);
                }
                {
                    
                result.yOffset = decoder0.readLong(32);
                }
                {
                    
                result.uOffset = decoder0.readLong(40);
                }
                {
                    
                result.vOffset = decoder0.readLong(48);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.frameData, 8, false);
        
        encoder0.encode(this.yStride, 12);
        
        encoder0.encode(this.frameDataSize, 16);
        
        encoder0.encode(this.uStride, 24);
        
        encoder0.encode(this.vStride, 28);
        
        encoder0.encode(this.yOffset, 32);
        
        encoder0.encode(this.uOffset, 40);
        
        encoder0.encode(this.vOffset, 48);
    }
}