
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class PredictionFeatures extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int profile;
    public com.vccorp.gfx.mojom.Size videoSize;
    public int framesPerSec;
    public String keySystem;
    public boolean useHwSecureCodecs;

    private PredictionFeatures(int version) {
        super(STRUCT_SIZE, version);
        this.framesPerSec = (int) 0;
        this.useHwSecureCodecs = (boolean) false;
    }

    public PredictionFeatures() {
        this(0);
    }

    public static PredictionFeatures deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static PredictionFeatures deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static PredictionFeatures decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        PredictionFeatures result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new PredictionFeatures(elementsOrVersion);
                {
                    
                result.profile = decoder0.readInt(8);
                    VideoCodecProfile.validate(result.profile);
                }
                {
                    
                result.framesPerSec = decoder0.readInt(12);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.videoSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.keySystem = decoder0.readString(24, false);
                }
                {
                    
                result.useHwSecureCodecs = decoder0.readBoolean(32, 0);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.profile, 8);
        
        encoder0.encode(this.framesPerSec, 12);
        
        encoder0.encode(this.videoSize, 16, false);
        
        encoder0.encode(this.keySystem, 24, false);
        
        encoder0.encode(this.useHwSecureCodecs, 32, 0);
    }
}