
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/output_protection.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface OutputProtection extends com.vccorp.mojo.bindings.Interface {



    public static final class ProtectionType {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int NONE = 0;
        public static final int HDCP = 1;

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 1;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private ProtectionType() {}
    }


    public static final class LinkType {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int NONE = 0;
        public static final int UNKNOWN = 1;
        public static final int INTERNAL = 2;
        public static final int VGA = 4;
        public static final int HDMI = 8;
        public static final int DVI = 16;
        public static final int DISPLAYPORT = 32;
        public static final int NETWORK = 64;

        public static boolean isKnownValue(int value) {
            switch (value) {
                case 0:
                case 1:
                case 2:
                case 4:
                case 8:
                case 16:
                case 32:
                case 64:
                    return true;
            }
            return false;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private LinkType() {}
    }


    public interface Proxy extends OutputProtection, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<OutputProtection, OutputProtection.Proxy> MANAGER = OutputProtection_Internal.MANAGER;


    void queryStatus(

QueryStatusResponse callback);

    interface QueryStatusResponse extends com.vccorp.mojo.bindings.Callbacks.Callback3<Boolean, Integer, Integer> { }



    void enableProtection(
int desiredProtectionMask, 
EnableProtectionResponse callback);

    interface EnableProtectionResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Boolean> { }


}
