
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/mjpeg_decode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MjpegDecodeAccelerator_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MjpegDecodeAccelerator, MjpegDecodeAccelerator.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MjpegDecodeAccelerator, MjpegDecodeAccelerator.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.MjpegDecodeAccelerator";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MjpegDecodeAccelerator impl) {
            return new Stub(core, impl);
        }

        @Override
        public MjpegDecodeAccelerator[] buildArray(int size) {
          return new MjpegDecodeAccelerator[size];
        }
    };


    private static final int INITIALIZE_ORDINAL = 0;

    private static final int DECODE_ORDINAL = 1;

    private static final int DECODE_WITH_FD_ORDINAL = 2;

    private static final int UNINITIALIZE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MjpegDecodeAccelerator.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initialize(

InitializeResponse callback) {

            MjpegDecodeAcceleratorInitializeParams _message = new MjpegDecodeAcceleratorInitializeParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MjpegDecodeAcceleratorInitializeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void decode(
BitstreamBuffer inputBuffer, com.vccorp.gfx.mojom.Size codedSize, com.vccorp.mojo.system.SharedBufferHandle outputHandle, int outputBufferSize,
DecodeResponse callback) {

            MjpegDecodeAcceleratorDecodeParams _message = new MjpegDecodeAcceleratorDecodeParams();

            _message.inputBuffer = inputBuffer;

            _message.codedSize = codedSize;

            _message.outputHandle = outputHandle;

            _message.outputBufferSize = outputBufferSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MjpegDecodeAcceleratorDecodeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void decodeWithFd(
int bufferId, com.vccorp.mojo.system.UntypedHandle inputFd, int inputBufferSize, int codedSizeWidth, int codedSizeHeight, com.vccorp.mojo.system.UntypedHandle outputFd, int outputBufferSize,
DecodeWithFdResponse callback) {

            MjpegDecodeAcceleratorDecodeWithFdParams _message = new MjpegDecodeAcceleratorDecodeWithFdParams();

            _message.bufferId = bufferId;

            _message.inputFd = inputFd;

            _message.inputBufferSize = inputBufferSize;

            _message.codedSizeWidth = codedSizeWidth;

            _message.codedSizeHeight = codedSizeHeight;

            _message.outputFd = outputFd;

            _message.outputBufferSize = outputBufferSize;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECODE_WITH_FD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MjpegDecodeAcceleratorDecodeWithFdResponseParamsForwardToCallback(callback));

        }


        @Override
        public void uninitialize(
) {

            MjpegDecodeAcceleratorUninitializeParams _message = new MjpegDecodeAcceleratorUninitializeParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UNINITIALIZE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MjpegDecodeAccelerator> {

        Stub(com.vccorp.mojo.system.Core core, MjpegDecodeAccelerator impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MjpegDecodeAccelerator_Internal.MANAGER, messageWithHeader);











                    case UNINITIALIZE_ORDINAL: {

                        MjpegDecodeAcceleratorUninitializeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().uninitialize();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MjpegDecodeAccelerator_Internal.MANAGER, messageWithHeader, receiver);







                    case INITIALIZE_ORDINAL: {

                        MjpegDecodeAcceleratorInitializeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initialize(new MjpegDecodeAcceleratorInitializeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DECODE_ORDINAL: {

                        MjpegDecodeAcceleratorDecodeParams data =
                                MjpegDecodeAcceleratorDecodeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().decode(data.inputBuffer, data.codedSize, data.outputHandle, data.outputBufferSize, new MjpegDecodeAcceleratorDecodeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DECODE_WITH_FD_ORDINAL: {

                        MjpegDecodeAcceleratorDecodeWithFdParams data =
                                MjpegDecodeAcceleratorDecodeWithFdParams.deserialize(messageWithHeader.getPayload());

                        getImpl().decodeWithFd(data.bufferId, data.inputFd, data.inputBufferSize, data.codedSizeWidth, data.codedSizeHeight, data.outputFd, data.outputBufferSize, new MjpegDecodeAcceleratorDecodeWithFdResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MjpegDecodeAcceleratorInitializeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MjpegDecodeAcceleratorInitializeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MjpegDecodeAcceleratorInitializeParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorInitializeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorInitializeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorInitializeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorInitializeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorInitializeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MjpegDecodeAcceleratorInitializeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private MjpegDecodeAcceleratorInitializeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MjpegDecodeAcceleratorInitializeResponseParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorInitializeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorInitializeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorInitializeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorInitializeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorInitializeResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class MjpegDecodeAcceleratorInitializeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MjpegDecodeAccelerator.InitializeResponse mCallback;

        MjpegDecodeAcceleratorInitializeResponseParamsForwardToCallback(MjpegDecodeAccelerator.InitializeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(INITIALIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MjpegDecodeAcceleratorInitializeResponseParams response = MjpegDecodeAcceleratorInitializeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MjpegDecodeAcceleratorInitializeResponseParamsProxyToResponder implements MjpegDecodeAccelerator.InitializeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MjpegDecodeAcceleratorInitializeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            MjpegDecodeAcceleratorInitializeResponseParams _response = new MjpegDecodeAcceleratorInitializeResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIALIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MjpegDecodeAcceleratorDecodeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BitstreamBuffer inputBuffer;
        public com.vccorp.gfx.mojom.Size codedSize;
        public com.vccorp.mojo.system.SharedBufferHandle outputHandle;
        public int outputBufferSize;

        private MjpegDecodeAcceleratorDecodeParams(int version) {
            super(STRUCT_SIZE, version);
            this.outputHandle = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public MjpegDecodeAcceleratorDecodeParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorDecodeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorDecodeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorDecodeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorDecodeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorDecodeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.inputBuffer = BitstreamBuffer.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.codedSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }
                    {
                        
                    result.outputHandle = decoder0.readSharedBufferHandle(24, false);
                    }
                    {
                        
                    result.outputBufferSize = decoder0.readInt(28);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.inputBuffer, 8, false);
            
            encoder0.encode(this.codedSize, 16, false);
            
            encoder0.encode(this.outputHandle, 24, false);
            
            encoder0.encode(this.outputBufferSize, 28);
        }
    }



    
    static final class MjpegDecodeAcceleratorDecodeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int bitstreamBufferId;
        public int error;

        private MjpegDecodeAcceleratorDecodeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MjpegDecodeAcceleratorDecodeResponseParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorDecodeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorDecodeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorDecodeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorDecodeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorDecodeResponseParams(elementsOrVersion);
                    {
                        
                    result.bitstreamBufferId = decoder0.readInt(8);
                    }
                    {
                        
                    result.error = decoder0.readInt(12);
                        DecodeError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bitstreamBufferId, 8);
            
            encoder0.encode(this.error, 12);
        }
    }

    static class MjpegDecodeAcceleratorDecodeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MjpegDecodeAccelerator.DecodeResponse mCallback;

        MjpegDecodeAcceleratorDecodeResponseParamsForwardToCallback(MjpegDecodeAccelerator.DecodeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DECODE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MjpegDecodeAcceleratorDecodeResponseParams response = MjpegDecodeAcceleratorDecodeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.bitstreamBufferId, response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MjpegDecodeAcceleratorDecodeResponseParamsProxyToResponder implements MjpegDecodeAccelerator.DecodeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MjpegDecodeAcceleratorDecodeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer bitstreamBufferId, Integer error) {
            MjpegDecodeAcceleratorDecodeResponseParams _response = new MjpegDecodeAcceleratorDecodeResponseParams();

            _response.bitstreamBufferId = bitstreamBufferId;

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECODE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MjpegDecodeAcceleratorDecodeWithFdParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int bufferId;
        public com.vccorp.mojo.system.UntypedHandle inputFd;
        public int inputBufferSize;
        public int codedSizeWidth;
        public int codedSizeHeight;
        public com.vccorp.mojo.system.UntypedHandle outputFd;
        public int outputBufferSize;

        private MjpegDecodeAcceleratorDecodeWithFdParams(int version) {
            super(STRUCT_SIZE, version);
            this.inputFd = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.outputFd = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public MjpegDecodeAcceleratorDecodeWithFdParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorDecodeWithFdParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorDecodeWithFdParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorDecodeWithFdParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorDecodeWithFdParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorDecodeWithFdParams(elementsOrVersion);
                    {
                        
                    result.bufferId = decoder0.readInt(8);
                    }
                    {
                        
                    result.inputFd = decoder0.readUntypedHandle(12, false);
                    }
                    {
                        
                    result.inputBufferSize = decoder0.readInt(16);
                    }
                    {
                        
                    result.codedSizeWidth = decoder0.readInt(20);
                    }
                    {
                        
                    result.codedSizeHeight = decoder0.readInt(24);
                    }
                    {
                        
                    result.outputFd = decoder0.readUntypedHandle(28, false);
                    }
                    {
                        
                    result.outputBufferSize = decoder0.readInt(32);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bufferId, 8);
            
            encoder0.encode(this.inputFd, 12, false);
            
            encoder0.encode(this.inputBufferSize, 16);
            
            encoder0.encode(this.codedSizeWidth, 20);
            
            encoder0.encode(this.codedSizeHeight, 24);
            
            encoder0.encode(this.outputFd, 28, false);
            
            encoder0.encode(this.outputBufferSize, 32);
        }
    }



    
    static final class MjpegDecodeAcceleratorDecodeWithFdResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int bufferId;
        public int error;

        private MjpegDecodeAcceleratorDecodeWithFdResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MjpegDecodeAcceleratorDecodeWithFdResponseParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorDecodeWithFdResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorDecodeWithFdResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorDecodeWithFdResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorDecodeWithFdResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorDecodeWithFdResponseParams(elementsOrVersion);
                    {
                        
                    result.bufferId = decoder0.readInt(8);
                    }
                    {
                        
                    result.error = decoder0.readInt(12);
                        DecodeError.validate(result.error);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.bufferId, 8);
            
            encoder0.encode(this.error, 12);
        }
    }

    static class MjpegDecodeAcceleratorDecodeWithFdResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MjpegDecodeAccelerator.DecodeWithFdResponse mCallback;

        MjpegDecodeAcceleratorDecodeWithFdResponseParamsForwardToCallback(MjpegDecodeAccelerator.DecodeWithFdResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DECODE_WITH_FD_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MjpegDecodeAcceleratorDecodeWithFdResponseParams response = MjpegDecodeAcceleratorDecodeWithFdResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.bufferId, response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MjpegDecodeAcceleratorDecodeWithFdResponseParamsProxyToResponder implements MjpegDecodeAccelerator.DecodeWithFdResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MjpegDecodeAcceleratorDecodeWithFdResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer bufferId, Integer error) {
            MjpegDecodeAcceleratorDecodeWithFdResponseParams _response = new MjpegDecodeAcceleratorDecodeWithFdResponseParams();

            _response.bufferId = bufferId;

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DECODE_WITH_FD_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MjpegDecodeAcceleratorUninitializeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MjpegDecodeAcceleratorUninitializeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MjpegDecodeAcceleratorUninitializeParams() {
            this(0);
        }

        public static MjpegDecodeAcceleratorUninitializeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MjpegDecodeAcceleratorUninitializeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MjpegDecodeAcceleratorUninitializeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MjpegDecodeAcceleratorUninitializeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MjpegDecodeAcceleratorUninitializeParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
