
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/renderer_extensions.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaPlayerRendererExtension_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaPlayerRendererExtension, MediaPlayerRendererExtension.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaPlayerRendererExtension, MediaPlayerRendererExtension.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.MediaPlayerRendererExtension";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaPlayerRendererExtension impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaPlayerRendererExtension[] buildArray(int size) {
          return new MediaPlayerRendererExtension[size];
        }
    };


    private static final int INITIATE_SCOPED_SURFACE_REQUEST_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaPlayerRendererExtension.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void initiateScopedSurfaceRequest(

InitiateScopedSurfaceRequestResponse callback) {

            MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams _message = new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIATE_SCOPED_SURFACE_REQUEST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaPlayerRendererExtension> {

        Stub(com.vccorp.mojo.system.Core core, MediaPlayerRendererExtension impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaPlayerRendererExtension_Internal.MANAGER, messageWithHeader);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaPlayerRendererExtension_Internal.MANAGER, messageWithHeader, receiver);







                    case INITIATE_SCOPED_SURFACE_REQUEST_ORDINAL: {

                        MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams.deserialize(messageWithHeader.getPayload());

                        getImpl().initiateScopedSurfaceRequest(new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams() {
            this(0);
        }

        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken requestToken;

        private MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams() {
            this(0);
        }

        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.requestToken = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestToken, 8, false);
        }
    }

    static class MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaPlayerRendererExtension.InitiateScopedSurfaceRequestResponse mCallback;

        MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsForwardToCallback(MediaPlayerRendererExtension.InitiateScopedSurfaceRequestResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(INITIATE_SCOPED_SURFACE_REQUEST_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams response = MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.requestToken);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsProxyToResponder implements MediaPlayerRendererExtension.InitiateScopedSurfaceRequestResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.UnguessableToken requestToken) {
            MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams _response = new MediaPlayerRendererExtensionInitiateScopedSurfaceRequestResponseParams();

            _response.requestToken = requestToken;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    INITIATE_SCOPED_SURFACE_REQUEST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
