
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class MailboxBufferHandleSet extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 16;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public com.vccorp.gpu.mojom.MailboxHolder[] mailboxHolder;

    private MailboxBufferHandleSet(int version) {
        super(STRUCT_SIZE, version);
    }

    public MailboxBufferHandleSet() {
        this(0);
    }

    public static MailboxBufferHandleSet deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static MailboxBufferHandleSet deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static MailboxBufferHandleSet decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        MailboxBufferHandleSet result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new MailboxBufferHandleSet(elementsOrVersion);
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(4);
                    result.mailboxHolder = new com.vccorp.gpu.mojom.MailboxHolder[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.mailboxHolder[i1] = com.vccorp.gpu.mojom.MailboxHolder.decode(decoder2);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        if (this.mailboxHolder == null) {
            encoder0.encodeNullPointer(8, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.mailboxHolder.length, 8, 4);
            for (int i0 = 0; i0 < this.mailboxHolder.length; ++i0) {
                
                encoder1.encode(this.mailboxHolder[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }
}