
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/content_decryption_module.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ContentDecryptionModuleClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ContentDecryptionModuleClient, ContentDecryptionModuleClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ContentDecryptionModuleClient, ContentDecryptionModuleClient.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.ContentDecryptionModuleClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ContentDecryptionModuleClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public ContentDecryptionModuleClient[] buildArray(int size) {
          return new ContentDecryptionModuleClient[size];
        }
    };


    private static final int ON_SESSION_MESSAGE_ORDINAL = 0;

    private static final int ON_SESSION_CLOSED_ORDINAL = 1;

    private static final int ON_SESSION_KEYS_CHANGE_ORDINAL = 2;

    private static final int ON_SESSION_EXPIRATION_UPDATE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ContentDecryptionModuleClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onSessionMessage(
String sessionId, int messageType, byte[] message) {

            ContentDecryptionModuleClientOnSessionMessageParams _message = new ContentDecryptionModuleClientOnSessionMessageParams();

            _message.sessionId = sessionId;

            _message.messageType = messageType;

            _message.message = message;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SESSION_MESSAGE_ORDINAL)));

        }


        @Override
        public void onSessionClosed(
String sessionId) {

            ContentDecryptionModuleClientOnSessionClosedParams _message = new ContentDecryptionModuleClientOnSessionClosedParams();

            _message.sessionId = sessionId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SESSION_CLOSED_ORDINAL)));

        }


        @Override
        public void onSessionKeysChange(
String sessionId, boolean hasAdditionalUsableKey, CdmKeyInformation[] keysInfo) {

            ContentDecryptionModuleClientOnSessionKeysChangeParams _message = new ContentDecryptionModuleClientOnSessionKeysChangeParams();

            _message.sessionId = sessionId;

            _message.hasAdditionalUsableKey = hasAdditionalUsableKey;

            _message.keysInfo = keysInfo;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SESSION_KEYS_CHANGE_ORDINAL)));

        }


        @Override
        public void onSessionExpirationUpdate(
String sessionId, double newExpiryTimeSec) {

            ContentDecryptionModuleClientOnSessionExpirationUpdateParams _message = new ContentDecryptionModuleClientOnSessionExpirationUpdateParams();

            _message.sessionId = sessionId;

            _message.newExpiryTimeSec = newExpiryTimeSec;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SESSION_EXPIRATION_UPDATE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ContentDecryptionModuleClient> {

        Stub(com.vccorp.mojo.system.Core core, ContentDecryptionModuleClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ContentDecryptionModuleClient_Internal.MANAGER, messageWithHeader);





                    case ON_SESSION_MESSAGE_ORDINAL: {

                        ContentDecryptionModuleClientOnSessionMessageParams data =
                                ContentDecryptionModuleClientOnSessionMessageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSessionMessage(data.sessionId, data.messageType, data.message);
                        return true;
                    }





                    case ON_SESSION_CLOSED_ORDINAL: {

                        ContentDecryptionModuleClientOnSessionClosedParams data =
                                ContentDecryptionModuleClientOnSessionClosedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSessionClosed(data.sessionId);
                        return true;
                    }





                    case ON_SESSION_KEYS_CHANGE_ORDINAL: {

                        ContentDecryptionModuleClientOnSessionKeysChangeParams data =
                                ContentDecryptionModuleClientOnSessionKeysChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSessionKeysChange(data.sessionId, data.hasAdditionalUsableKey, data.keysInfo);
                        return true;
                    }





                    case ON_SESSION_EXPIRATION_UPDATE_ORDINAL: {

                        ContentDecryptionModuleClientOnSessionExpirationUpdateParams data =
                                ContentDecryptionModuleClientOnSessionExpirationUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onSessionExpirationUpdate(data.sessionId, data.newExpiryTimeSec);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ContentDecryptionModuleClient_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ContentDecryptionModuleClientOnSessionMessageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String sessionId;
        public int messageType;
        public byte[] message;

        private ContentDecryptionModuleClientOnSessionMessageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ContentDecryptionModuleClientOnSessionMessageParams() {
            this(0);
        }

        public static ContentDecryptionModuleClientOnSessionMessageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ContentDecryptionModuleClientOnSessionMessageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ContentDecryptionModuleClientOnSessionMessageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ContentDecryptionModuleClientOnSessionMessageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ContentDecryptionModuleClientOnSessionMessageParams(elementsOrVersion);
                    {
                        
                    result.sessionId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.messageType = decoder0.readInt(16);
                        CdmMessageType.validate(result.messageType);
                    }
                    {
                        
                    result.message = decoder0.readBytes(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sessionId, 8, false);
            
            encoder0.encode(this.messageType, 16);
            
            encoder0.encode(this.message, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class ContentDecryptionModuleClientOnSessionClosedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String sessionId;

        private ContentDecryptionModuleClientOnSessionClosedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ContentDecryptionModuleClientOnSessionClosedParams() {
            this(0);
        }

        public static ContentDecryptionModuleClientOnSessionClosedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ContentDecryptionModuleClientOnSessionClosedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ContentDecryptionModuleClientOnSessionClosedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ContentDecryptionModuleClientOnSessionClosedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ContentDecryptionModuleClientOnSessionClosedParams(elementsOrVersion);
                    {
                        
                    result.sessionId = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sessionId, 8, false);
        }
    }



    
    static final class ContentDecryptionModuleClientOnSessionKeysChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String sessionId;
        public boolean hasAdditionalUsableKey;
        public CdmKeyInformation[] keysInfo;

        private ContentDecryptionModuleClientOnSessionKeysChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ContentDecryptionModuleClientOnSessionKeysChangeParams() {
            this(0);
        }

        public static ContentDecryptionModuleClientOnSessionKeysChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ContentDecryptionModuleClientOnSessionKeysChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ContentDecryptionModuleClientOnSessionKeysChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ContentDecryptionModuleClientOnSessionKeysChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ContentDecryptionModuleClientOnSessionKeysChangeParams(elementsOrVersion);
                    {
                        
                    result.sessionId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.hasAdditionalUsableKey = decoder0.readBoolean(16, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.keysInfo = new CdmKeyInformation[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.keysInfo[i1] = CdmKeyInformation.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sessionId, 8, false);
            
            encoder0.encode(this.hasAdditionalUsableKey, 16, 0);
            
            if (this.keysInfo == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.keysInfo.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.keysInfo.length; ++i0) {
                    
                    encoder1.encode(this.keysInfo[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class ContentDecryptionModuleClientOnSessionExpirationUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String sessionId;
        public double newExpiryTimeSec;

        private ContentDecryptionModuleClientOnSessionExpirationUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ContentDecryptionModuleClientOnSessionExpirationUpdateParams() {
            this(0);
        }

        public static ContentDecryptionModuleClientOnSessionExpirationUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ContentDecryptionModuleClientOnSessionExpirationUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ContentDecryptionModuleClientOnSessionExpirationUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ContentDecryptionModuleClientOnSessionExpirationUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ContentDecryptionModuleClientOnSessionExpirationUpdateParams(elementsOrVersion);
                    {
                        
                    result.sessionId = decoder0.readString(8, false);
                    }
                    {
                        
                    result.newExpiryTimeSec = decoder0.readDouble(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sessionId, 8, false);
            
            encoder0.encode(this.newExpiryTimeSec, 16);
        }
    }



}
