
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/audio_decoder.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AudioDecoderClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AudioDecoderClient, AudioDecoderClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AudioDecoderClient, AudioDecoderClient.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.AudioDecoderClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AudioDecoderClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public AudioDecoderClient[] buildArray(int size) {
          return new AudioDecoderClient[size];
        }
    };


    private static final int ON_BUFFER_DECODED_ORDINAL = 0;

    private static final int ON_WAITING_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AudioDecoderClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onBufferDecoded(
AudioBuffer buffer) {

            AudioDecoderClientOnBufferDecodedParams _message = new AudioDecoderClientOnBufferDecodedParams();

            _message.buffer = buffer;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_BUFFER_DECODED_ORDINAL)));

        }


        @Override
        public void onWaiting(
int reason) {

            AudioDecoderClientOnWaitingParams _message = new AudioDecoderClientOnWaitingParams();

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_WAITING_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AudioDecoderClient> {

        Stub(com.vccorp.mojo.system.Core core, AudioDecoderClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AudioDecoderClient_Internal.MANAGER, messageWithHeader);





                    case ON_BUFFER_DECODED_ORDINAL: {

                        AudioDecoderClientOnBufferDecodedParams data =
                                AudioDecoderClientOnBufferDecodedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onBufferDecoded(data.buffer);
                        return true;
                    }





                    case ON_WAITING_ORDINAL: {

                        AudioDecoderClientOnWaitingParams data =
                                AudioDecoderClientOnWaitingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onWaiting(data.reason);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AudioDecoderClient_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AudioDecoderClientOnBufferDecodedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioBuffer buffer;

        private AudioDecoderClientOnBufferDecodedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioDecoderClientOnBufferDecodedParams() {
            this(0);
        }

        public static AudioDecoderClientOnBufferDecodedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioDecoderClientOnBufferDecodedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioDecoderClientOnBufferDecodedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioDecoderClientOnBufferDecodedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioDecoderClientOnBufferDecodedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.buffer = AudioBuffer.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.buffer, 8, false);
        }
    }



    
    static final class AudioDecoderClientOnWaitingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int reason;

        private AudioDecoderClientOnWaitingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AudioDecoderClientOnWaitingParams() {
            this(0);
        }

        public static AudioDecoderClientOnWaitingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AudioDecoderClientOnWaitingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AudioDecoderClientOnWaitingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AudioDecoderClientOnWaitingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AudioDecoderClientOnWaitingParams(elementsOrVersion);
                    {
                        
                    result.reason = decoder0.readInt(8);
                        WaitingReason.validate(result.reason);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reason, 8);
        }
    }



}
