
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/media_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class AudioBuffer extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int sampleFormat;
    public int channelLayout;
    public int channelCount;
    public int sampleRate;
    public int frameCount;
    public boolean endOfStream;
    public com.vccorp.mojo_base.mojom.TimeDelta timestamp;
    public byte[] data;

    private AudioBuffer(int version) {
        super(STRUCT_SIZE, version);
    }

    public AudioBuffer() {
        this(0);
    }

    public static AudioBuffer deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static AudioBuffer deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static AudioBuffer decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        AudioBuffer result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new AudioBuffer(elementsOrVersion);
                {
                    
                result.sampleFormat = decoder0.readInt(8);
                    SampleFormat.validate(result.sampleFormat);
                }
                {
                    
                result.channelLayout = decoder0.readInt(12);
                    ChannelLayout.validate(result.channelLayout);
                }
                {
                    
                result.channelCount = decoder0.readInt(16);
                }
                {
                    
                result.sampleRate = decoder0.readInt(20);
                }
                {
                    
                result.frameCount = decoder0.readInt(24);
                }
                {
                    
                result.endOfStream = decoder0.readBoolean(28, 0);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.timestamp = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.data = decoder0.readBytes(40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.sampleFormat, 8);
        
        encoder0.encode(this.channelLayout, 12);
        
        encoder0.encode(this.channelCount, 16);
        
        encoder0.encode(this.sampleRate, 20);
        
        encoder0.encode(this.frameCount, 24);
        
        encoder0.encode(this.endOfStream, 28, 0);
        
        encoder0.encode(this.timestamp, 32, false);
        
        encoder0.encode(this.data, 40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}