
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     gpu/ipc/common/gpu_info.mojom
//

package com.vccorp.gpu.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class ImageDecodeAcceleratorSupportedProfile extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int imageType;
    public com.vccorp.gfx.mojom.Size minEncodedDimensions;
    public com.vccorp.gfx.mojom.Size maxEncodedDimensions;
    public int[] subsamplings;

    private ImageDecodeAcceleratorSupportedProfile(int version) {
        super(STRUCT_SIZE, version);
    }

    public ImageDecodeAcceleratorSupportedProfile() {
        this(0);
    }

    public static ImageDecodeAcceleratorSupportedProfile deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static ImageDecodeAcceleratorSupportedProfile deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static ImageDecodeAcceleratorSupportedProfile decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        ImageDecodeAcceleratorSupportedProfile result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new ImageDecodeAcceleratorSupportedProfile(elementsOrVersion);
                {
                    
                result.imageType = decoder0.readInt(8);
                    ImageDecodeAcceleratorType.validate(result.imageType);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.minEncodedDimensions = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.maxEncodedDimensions = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.subsamplings = decoder0.readInts(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.subsamplings.length; ++i0) {
                        ImageDecodeAcceleratorSubsampling.validate(result.subsamplings[i0]);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.imageType, 8);
        
        encoder0.encode(this.minEncodedDimensions, 16, false);
        
        encoder0.encode(this.maxEncodedDimensions, 24, false);
        
        encoder0.encode(this.subsamplings, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}