
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/sensor.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class SensorType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int AMBIENT_LIGHT = 0;
    public static final int PROXIMITY = 1; // AMBIENT_LIGHT + 1
    public static final int ACCELEROMETER = 2; // PROXIMITY + 1
    public static final int LINEAR_ACCELERATION = 3; // ACCELEROMETER + 1
    public static final int GYROSCOPE = 4; // LINEAR_ACCELERATION + 1
    public static final int MAGNETOMETER = 5; // GYROSCOPE + 1
    public static final int PRESSURE = 6; // MAGNETOMETER + 1
    public static final int ABSOLUTE_ORIENTATION_EULER_ANGLES = 7; // PRESSURE + 1
    public static final int ABSOLUTE_ORIENTATION_QUATERNION = 8; // ABSOLUTE_ORIENTATION_EULER_ANGLES + 1
    public static final int RELATIVE_ORIENTATION_EULER_ANGLES = 9; // ABSOLUTE_ORIENTATION_QUATERNION + 1
    public static final int RELATIVE_ORIENTATION_QUATERNION = 10; // RELATIVE_ORIENTATION_EULER_ANGLES + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 10;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private SensorType() {}
}