
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/input_service.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class InputDeviceInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String id;
    public String name;
    public int subsystem;
    public int type;
    public boolean isAccelerometer;
    public boolean isJoystick;
    public boolean isKey;
    public boolean isKeyboard;
    public boolean isMouse;
    public boolean isTablet;
    public boolean isTouchpad;
    public boolean isTouchscreen;

    private InputDeviceInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public InputDeviceInfo() {
        this(0);
    }

    public static InputDeviceInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static InputDeviceInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static InputDeviceInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        InputDeviceInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new InputDeviceInfo(elementsOrVersion);
                {
                    
                result.id = decoder0.readString(8, false);
                }
                {
                    
                result.name = decoder0.readString(16, false);
                }
                {
                    
                result.subsystem = decoder0.readInt(24);
                    InputDeviceSubsystem.validate(result.subsystem);
                }
                {
                    
                result.type = decoder0.readInt(28);
                    InputDeviceType.validate(result.type);
                }
                {
                    
                result.isAccelerometer = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.isJoystick = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.isKey = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.isKeyboard = decoder0.readBoolean(32, 3);
                }
                {
                    
                result.isMouse = decoder0.readBoolean(32, 4);
                }
                {
                    
                result.isTablet = decoder0.readBoolean(32, 5);
                }
                {
                    
                result.isTouchpad = decoder0.readBoolean(32, 6);
                }
                {
                    
                result.isTouchscreen = decoder0.readBoolean(32, 7);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.id, 8, false);
        
        encoder0.encode(this.name, 16, false);
        
        encoder0.encode(this.subsystem, 24);
        
        encoder0.encode(this.type, 28);
        
        encoder0.encode(this.isAccelerometer, 32, 0);
        
        encoder0.encode(this.isJoystick, 32, 1);
        
        encoder0.encode(this.isKey, 32, 2);
        
        encoder0.encode(this.isKeyboard, 32, 3);
        
        encoder0.encode(this.isMouse, 32, 4);
        
        encoder0.encode(this.isTablet, 32, 5);
        
        encoder0.encode(this.isTouchpad, 32, 6);
        
        encoder0.encode(this.isTouchscreen, 32, 7);
    }
}