
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/hid.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class HidDeviceInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 96;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(96, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public String guid;
    public short vendorId;
    public short productId;
    public String productName;
    public String serialNumber;
    public int busType;
    public byte[] reportDescriptor;
    public HidCollectionInfo[] collections;
    public boolean hasReportId;
    public long maxInputReportSize;
    public long maxOutputReportSize;
    public long maxFeatureReportSize;
    public String deviceNode;

    private HidDeviceInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public HidDeviceInfo() {
        this(0);
    }

    public static HidDeviceInfo deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static HidDeviceInfo deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static HidDeviceInfo decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        HidDeviceInfo result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new HidDeviceInfo(elementsOrVersion);
                {
                    
                result.guid = decoder0.readString(8, false);
                }
                {
                    
                result.vendorId = decoder0.readShort(16);
                }
                {
                    
                result.productId = decoder0.readShort(18);
                }
                {
                    
                result.busType = decoder0.readInt(20);
                    HidBusType.validate(result.busType);
                }
                {
                    
                result.productName = decoder0.readString(24, false);
                }
                {
                    
                result.serialNumber = decoder0.readString(32, false);
                }
                {
                    
                result.reportDescriptor = decoder0.readBytes(40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                {
                    com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.collections = new HidCollectionInfo[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        
                        com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        result.collections[i1] = HidCollectionInfo.decode(decoder2);
                    }
                }
                }
                {
                    
                result.hasReportId = decoder0.readBoolean(56, 0);
                }
                {
                    
                result.maxInputReportSize = decoder0.readLong(64);
                }
                {
                    
                result.maxOutputReportSize = decoder0.readLong(72);
                }
                {
                    
                result.maxFeatureReportSize = decoder0.readLong(80);
                }
                {
                    
                result.deviceNode = decoder0.readString(88, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.guid, 8, false);
        
        encoder0.encode(this.vendorId, 16);
        
        encoder0.encode(this.productId, 18);
        
        encoder0.encode(this.busType, 20);
        
        encoder0.encode(this.productName, 24, false);
        
        encoder0.encode(this.serialNumber, 32, false);
        
        encoder0.encode(this.reportDescriptor, 40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        if (this.collections == null) {
            encoder0.encodeNullPointer(48, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.collections.length, 48, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < this.collections.length; ++i0) {
                
                encoder1.encode(this.collections[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        
        encoder0.encode(this.hasReportId, 56, 0);
        
        encoder0.encode(this.maxInputReportSize, 64);
        
        encoder0.encode(this.maxOutputReportSize, 72);
        
        encoder0.encode(this.maxFeatureReportSize, 80);
        
        encoder0.encode(this.deviceNode, 88, false);
    }
}