
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/bluetooth_system.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BluetoothSystem_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BluetoothSystem, BluetoothSystem.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BluetoothSystem, BluetoothSystem.Proxy>() {

        @Override
        public String getName() {
            return "device.mojom.BluetoothSystem";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BluetoothSystem impl) {
            return new Stub(core, impl);
        }

        @Override
        public BluetoothSystem[] buildArray(int size) {
          return new BluetoothSystem[size];
        }
    };


    private static final int GET_STATE_ORDINAL = 0;

    private static final int SET_POWERED_ORDINAL = 1;

    private static final int GET_SCAN_STATE_ORDINAL = 2;

    private static final int START_SCAN_ORDINAL = 3;

    private static final int STOP_SCAN_ORDINAL = 4;

    private static final int GET_AVAILABLE_DEVICES_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BluetoothSystem.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getState(

GetStateResponse callback) {

            BluetoothSystemGetStateParams _message = new BluetoothSystemGetStateParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemGetStateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setPowered(
boolean powered, 
SetPoweredResponse callback) {

            BluetoothSystemSetPoweredParams _message = new BluetoothSystemSetPoweredParams();

            _message.powered = powered;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_POWERED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemSetPoweredResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getScanState(

GetScanStateResponse callback) {

            BluetoothSystemGetScanStateParams _message = new BluetoothSystemGetScanStateParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SCAN_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemGetScanStateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void startScan(

StartScanResponse callback) {

            BluetoothSystemStartScanParams _message = new BluetoothSystemStartScanParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_SCAN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemStartScanResponseParamsForwardToCallback(callback));

        }


        @Override
        public void stopScan(

StopScanResponse callback) {

            BluetoothSystemStopScanParams _message = new BluetoothSystemStopScanParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    STOP_SCAN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemStopScanResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getAvailableDevices(

GetAvailableDevicesResponse callback) {

            BluetoothSystemGetAvailableDevicesParams _message = new BluetoothSystemGetAvailableDevicesParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AVAILABLE_DEVICES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BluetoothSystemGetAvailableDevicesResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BluetoothSystem> {

        Stub(com.vccorp.mojo.system.Core core, BluetoothSystem impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BluetoothSystem_Internal.MANAGER, messageWithHeader);














                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BluetoothSystem_Internal.MANAGER, messageWithHeader, receiver);







                    case GET_STATE_ORDINAL: {

                        BluetoothSystemGetStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getState(new BluetoothSystemGetStateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_POWERED_ORDINAL: {

                        BluetoothSystemSetPoweredParams data =
                                BluetoothSystemSetPoweredParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setPowered(data.powered, new BluetoothSystemSetPoweredResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_SCAN_STATE_ORDINAL: {

                        BluetoothSystemGetScanStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getScanState(new BluetoothSystemGetScanStateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case START_SCAN_ORDINAL: {

                        BluetoothSystemStartScanParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startScan(new BluetoothSystemStartScanResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case STOP_SCAN_ORDINAL: {

                        BluetoothSystemStopScanParams.deserialize(messageWithHeader.getPayload());

                        getImpl().stopScan(new BluetoothSystemStopScanResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_AVAILABLE_DEVICES_ORDINAL: {

                        BluetoothSystemGetAvailableDevicesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAvailableDevices(new BluetoothSystemGetAvailableDevicesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BluetoothSystemGetStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BluetoothSystemGetStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetStateParams() {
            this(0);
        }

        public static BluetoothSystemGetStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetStateParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BluetoothSystemGetStateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int state;

        private BluetoothSystemGetStateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetStateResponseParams() {
            this(0);
        }

        public static BluetoothSystemGetStateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetStateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetStateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetStateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetStateResponseParams(elementsOrVersion);
                    {
                        
                    result.state = decoder0.readInt(8);
                        BluetoothSystem.State.validate(result.state);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8);
        }
    }

    static class BluetoothSystemGetStateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.GetStateResponse mCallback;

        BluetoothSystemGetStateResponseParamsForwardToCallback(BluetoothSystem.GetStateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_STATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemGetStateResponseParams response = BluetoothSystemGetStateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.state);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemGetStateResponseParamsProxyToResponder implements BluetoothSystem.GetStateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemGetStateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer state) {
            BluetoothSystemGetStateResponseParams _response = new BluetoothSystemGetStateResponseParams();

            _response.state = state;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BluetoothSystemSetPoweredParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean powered;

        private BluetoothSystemSetPoweredParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemSetPoweredParams() {
            this(0);
        }

        public static BluetoothSystemSetPoweredParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemSetPoweredParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemSetPoweredParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemSetPoweredParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemSetPoweredParams(elementsOrVersion);
                    {
                        
                    result.powered = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.powered, 8, 0);
        }
    }



    
    static final class BluetoothSystemSetPoweredResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private BluetoothSystemSetPoweredResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemSetPoweredResponseParams() {
            this(0);
        }

        public static BluetoothSystemSetPoweredResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemSetPoweredResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemSetPoweredResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemSetPoweredResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemSetPoweredResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        BluetoothSystem.SetPoweredResult.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }

    static class BluetoothSystemSetPoweredResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.SetPoweredResponse mCallback;

        BluetoothSystemSetPoweredResponseParamsForwardToCallback(BluetoothSystem.SetPoweredResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_POWERED_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemSetPoweredResponseParams response = BluetoothSystemSetPoweredResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemSetPoweredResponseParamsProxyToResponder implements BluetoothSystem.SetPoweredResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemSetPoweredResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result) {
            BluetoothSystemSetPoweredResponseParams _response = new BluetoothSystemSetPoweredResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_POWERED_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BluetoothSystemGetScanStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BluetoothSystemGetScanStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetScanStateParams() {
            this(0);
        }

        public static BluetoothSystemGetScanStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetScanStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetScanStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetScanStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetScanStateParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BluetoothSystemGetScanStateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int scanState;

        private BluetoothSystemGetScanStateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetScanStateResponseParams() {
            this(0);
        }

        public static BluetoothSystemGetScanStateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetScanStateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetScanStateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetScanStateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetScanStateResponseParams(elementsOrVersion);
                    {
                        
                    result.scanState = decoder0.readInt(8);
                        BluetoothSystem.ScanState.validate(result.scanState);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.scanState, 8);
        }
    }

    static class BluetoothSystemGetScanStateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.GetScanStateResponse mCallback;

        BluetoothSystemGetScanStateResponseParamsForwardToCallback(BluetoothSystem.GetScanStateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_SCAN_STATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemGetScanStateResponseParams response = BluetoothSystemGetScanStateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.scanState);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemGetScanStateResponseParamsProxyToResponder implements BluetoothSystem.GetScanStateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemGetScanStateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer scanState) {
            BluetoothSystemGetScanStateResponseParams _response = new BluetoothSystemGetScanStateResponseParams();

            _response.scanState = scanState;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_SCAN_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BluetoothSystemStartScanParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BluetoothSystemStartScanParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemStartScanParams() {
            this(0);
        }

        public static BluetoothSystemStartScanParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemStartScanParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemStartScanParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemStartScanParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemStartScanParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BluetoothSystemStartScanResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private BluetoothSystemStartScanResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemStartScanResponseParams() {
            this(0);
        }

        public static BluetoothSystemStartScanResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemStartScanResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemStartScanResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemStartScanResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemStartScanResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        BluetoothSystem.StartScanResult.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }

    static class BluetoothSystemStartScanResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.StartScanResponse mCallback;

        BluetoothSystemStartScanResponseParamsForwardToCallback(BluetoothSystem.StartScanResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(START_SCAN_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemStartScanResponseParams response = BluetoothSystemStartScanResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemStartScanResponseParamsProxyToResponder implements BluetoothSystem.StartScanResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemStartScanResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result) {
            BluetoothSystemStartScanResponseParams _response = new BluetoothSystemStartScanResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_SCAN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BluetoothSystemStopScanParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BluetoothSystemStopScanParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemStopScanParams() {
            this(0);
        }

        public static BluetoothSystemStopScanParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemStopScanParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemStopScanParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemStopScanParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemStopScanParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BluetoothSystemStopScanResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;

        private BluetoothSystemStopScanResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemStopScanResponseParams() {
            this(0);
        }

        public static BluetoothSystemStopScanResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemStopScanResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemStopScanResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemStopScanResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemStopScanResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                        BluetoothSystem.StopScanResult.validate(result.result);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
        }
    }

    static class BluetoothSystemStopScanResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.StopScanResponse mCallback;

        BluetoothSystemStopScanResponseParamsForwardToCallback(BluetoothSystem.StopScanResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(STOP_SCAN_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemStopScanResponseParams response = BluetoothSystemStopScanResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemStopScanResponseParamsProxyToResponder implements BluetoothSystem.StopScanResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemStopScanResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result) {
            BluetoothSystemStopScanResponseParams _response = new BluetoothSystemStopScanResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    STOP_SCAN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BluetoothSystemGetAvailableDevicesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BluetoothSystemGetAvailableDevicesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetAvailableDevicesParams() {
            this(0);
        }

        public static BluetoothSystemGetAvailableDevicesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetAvailableDevicesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetAvailableDevicesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetAvailableDevicesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetAvailableDevicesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class BluetoothSystemGetAvailableDevicesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public BluetoothDeviceInfo[] devices;

        private BluetoothSystemGetAvailableDevicesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BluetoothSystemGetAvailableDevicesResponseParams() {
            this(0);
        }

        public static BluetoothSystemGetAvailableDevicesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BluetoothSystemGetAvailableDevicesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BluetoothSystemGetAvailableDevicesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BluetoothSystemGetAvailableDevicesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BluetoothSystemGetAvailableDevicesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.devices = new BluetoothDeviceInfo[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.devices[i1] = BluetoothDeviceInfo.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.devices == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.devices.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.devices.length; ++i0) {
                    
                    encoder1.encode(this.devices[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class BluetoothSystemGetAvailableDevicesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BluetoothSystem.GetAvailableDevicesResponse mCallback;

        BluetoothSystemGetAvailableDevicesResponseParamsForwardToCallback(BluetoothSystem.GetAvailableDevicesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_AVAILABLE_DEVICES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BluetoothSystemGetAvailableDevicesResponseParams response = BluetoothSystemGetAvailableDevicesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.devices);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BluetoothSystemGetAvailableDevicesResponseParamsProxyToResponder implements BluetoothSystem.GetAvailableDevicesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BluetoothSystemGetAvailableDevicesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(BluetoothDeviceInfo[] devices) {
            BluetoothSystemGetAvailableDevicesResponseParams _response = new BluetoothSystemGetAvailableDevicesResponseParams();

            _response.devices = devices;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AVAILABLE_DEVICES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
