
// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     java_cpp_enum.py
// From
//     ../../components/safe_browsing/db/v4_protocol_manager_util.h

package com.vccorp.components.safe_browsing;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@IntDef({
    SBThreatType.UNUSED, SBThreatType.SAFE, SBThreatType.URL_PHISHING, SBThreatType.URL_MALWARE,
    SBThreatType.URL_UNWANTED, SBThreatType.URL_BINARY_MALWARE,
    SBThreatType.URL_CLIENT_SIDE_PHISHING, SBThreatType.EXTENSION,
    SBThreatType.URL_CLIENT_SIDE_MALWARE, SBThreatType.BLACKLISTED_RESOURCE, SBThreatType.API_ABUSE,
    SBThreatType.SUBRESOURCE_FILTER, SBThreatType.CSD_WHITELIST,
    SBThreatType.DEPRECATED_URL_PASSWORD_PROTECTION_PHISHING, SBThreatType.SIGN_IN_PASSWORD_REUSE,
    SBThreatType.AD_SAMPLE, SBThreatType.SUSPICIOUS_SITE, SBThreatType.ENTERPRISE_PASSWORD_REUSE,
    SBThreatType.BILLING, SBThreatType.APK_DOWNLOAD
})
@Retention(RetentionPolicy.SOURCE)
public @interface SBThreatType {
  /**
   * This type can be used for lists that can be checked synchronously so a client callback isn't
   * required, or for whitelists.
   */
  int UNUSED = 0;
  /**
   * No threat at all.
   */
  int SAFE = 1;
  /**
   * The URL is being used for phishing.
   */
  int URL_PHISHING = 2;
  /**
   * The URL hosts malware.
   */
  int URL_MALWARE = 3;
  /**
   * The URL hosts unwanted programs.
   */
  int URL_UNWANTED = 4;
  /**
   * The download URL is malware.
   */
  int URL_BINARY_MALWARE = 5;
  /**
   * Url detected by the client-side phishing model.  Note that unlike the above values, this does
   * not correspond to a downloaded list.
   */
  int URL_CLIENT_SIDE_PHISHING = 6;
  /**
   * The Chrome extension or app (given by its ID) is malware.
   */
  int EXTENSION = 7;
  /**
   * Url detected by the client-side malware IP list. This IP list is part of the client side
   * detection model.
   */
  int URL_CLIENT_SIDE_MALWARE = 8;
  /**
   * Url leads to a blacklisted resource script. Note that no warnings should be shown on this
   * threat type, but an incident report might be sent.
   */
  int BLACKLISTED_RESOURCE = 9;
  /**
   * Url abuses a permission API.
   */
  int API_ABUSE = 10;
  /**
   * Activation patterns for the Subresource Filter.
   */
  int SUBRESOURCE_FILTER = 11;
  /**
   * CSD Phishing whitelist.  This "threat" means a URL matched the whitelist.
   */
  int CSD_WHITELIST = 12;
  /**
   * DEPRECATED. Url detected by password protection service.
   */
  int DEPRECATED_URL_PASSWORD_PROTECTION_PHISHING = 13;
  /**
   * Chrome sign in password reuse detected on low reputation page,
   */
  int SIGN_IN_PASSWORD_REUSE = 14;
  /**
   * A sample of an ad was collected
   */
  int AD_SAMPLE = 15;
  /**
   * The page loaded a resource from the Suspicious Site list.
   */
  int SUSPICIOUS_SITE = 16;
  /**
   * Enterprise password reuse detected on low reputation page.
   */
  int ENTERPRISE_PASSWORD_REUSE = 17;
  /**
   * Potential billing detected.
   */
  int BILLING = 18;
  /**
   * Off-market APK file downloaded, which could be potentially dangerous.
   */
  int APK_DOWNLOAD = 19;
}
