
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/webauthn/virtual_authenticator.mojom
//

package com.vccorp.blink.test.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class VirtualAuthenticatorManager_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<VirtualAuthenticatorManager, VirtualAuthenticatorManager.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<VirtualAuthenticatorManager, VirtualAuthenticatorManager.Proxy>() {

        @Override
        public String getName() {
            return "blink.test.mojom.VirtualAuthenticatorManager";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, VirtualAuthenticatorManager impl) {
            return new Stub(core, impl);
        }

        @Override
        public VirtualAuthenticatorManager[] buildArray(int size) {
          return new VirtualAuthenticatorManager[size];
        }
    };


    private static final int CREATE_AUTHENTICATOR_ORDINAL = 0;

    private static final int GET_AUTHENTICATORS_ORDINAL = 1;

    private static final int REMOVE_AUTHENTICATOR_ORDINAL = 2;

    private static final int CLEAR_AUTHENTICATORS_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements VirtualAuthenticatorManager.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void createAuthenticator(
VirtualAuthenticatorOptions options, 
CreateAuthenticatorResponse callback) {

            VirtualAuthenticatorManagerCreateAuthenticatorParams _message = new VirtualAuthenticatorManagerCreateAuthenticatorParams();

            _message.options = options;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_AUTHENTICATOR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getAuthenticators(

GetAuthenticatorsResponse callback) {

            VirtualAuthenticatorManagerGetAuthenticatorsParams _message = new VirtualAuthenticatorManagerGetAuthenticatorsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AUTHENTICATORS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void removeAuthenticator(
String id, 
RemoveAuthenticatorResponse callback) {

            VirtualAuthenticatorManagerRemoveAuthenticatorParams _message = new VirtualAuthenticatorManagerRemoveAuthenticatorParams();

            _message.id = id;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REMOVE_AUTHENTICATOR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearAuthenticators(

ClearAuthenticatorsResponse callback) {

            VirtualAuthenticatorManagerClearAuthenticatorsParams _message = new VirtualAuthenticatorManagerClearAuthenticatorsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_AUTHENTICATORS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<VirtualAuthenticatorManager> {

        Stub(com.vccorp.mojo.system.Core core, VirtualAuthenticatorManager impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                VirtualAuthenticatorManager_Internal.MANAGER, messageWithHeader);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), VirtualAuthenticatorManager_Internal.MANAGER, messageWithHeader, receiver);







                    case CREATE_AUTHENTICATOR_ORDINAL: {

                        VirtualAuthenticatorManagerCreateAuthenticatorParams data =
                                VirtualAuthenticatorManagerCreateAuthenticatorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createAuthenticator(data.options, new VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_AUTHENTICATORS_ORDINAL: {

                        VirtualAuthenticatorManagerGetAuthenticatorsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAuthenticators(new VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case REMOVE_AUTHENTICATOR_ORDINAL: {

                        VirtualAuthenticatorManagerRemoveAuthenticatorParams data =
                                VirtualAuthenticatorManagerRemoveAuthenticatorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().removeAuthenticator(data.id, new VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_AUTHENTICATORS_ORDINAL: {

                        VirtualAuthenticatorManagerClearAuthenticatorsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearAuthenticators(new VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class VirtualAuthenticatorManagerCreateAuthenticatorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VirtualAuthenticatorOptions options;

        private VirtualAuthenticatorManagerCreateAuthenticatorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerCreateAuthenticatorParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerCreateAuthenticatorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerCreateAuthenticatorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerCreateAuthenticatorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerCreateAuthenticatorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerCreateAuthenticatorParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.options = VirtualAuthenticatorOptions.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.options, 8, false);
        }
    }



    
    static final class VirtualAuthenticatorManagerCreateAuthenticatorResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VirtualAuthenticator authenticator;

        private VirtualAuthenticatorManagerCreateAuthenticatorResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerCreateAuthenticatorResponseParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerCreateAuthenticatorResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerCreateAuthenticatorResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerCreateAuthenticatorResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerCreateAuthenticatorResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerCreateAuthenticatorResponseParams(elementsOrVersion);
                    {
                        
                    result.authenticator = decoder0.readServiceInterface(8, false, VirtualAuthenticator.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.authenticator, 8, false, VirtualAuthenticator.MANAGER);
        }
    }

    static class VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VirtualAuthenticatorManager.CreateAuthenticatorResponse mCallback;

        VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsForwardToCallback(VirtualAuthenticatorManager.CreateAuthenticatorResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_AUTHENTICATOR_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VirtualAuthenticatorManagerCreateAuthenticatorResponseParams response = VirtualAuthenticatorManagerCreateAuthenticatorResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.authenticator);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsProxyToResponder implements VirtualAuthenticatorManager.CreateAuthenticatorResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VirtualAuthenticatorManagerCreateAuthenticatorResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(VirtualAuthenticator authenticator) {
            VirtualAuthenticatorManagerCreateAuthenticatorResponseParams _response = new VirtualAuthenticatorManagerCreateAuthenticatorResponseParams();

            _response.authenticator = authenticator;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_AUTHENTICATOR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VirtualAuthenticatorManagerGetAuthenticatorsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VirtualAuthenticatorManagerGetAuthenticatorsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerGetAuthenticatorsParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerGetAuthenticatorsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerGetAuthenticatorsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerGetAuthenticatorsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerGetAuthenticatorsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerGetAuthenticatorsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class VirtualAuthenticatorManagerGetAuthenticatorsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VirtualAuthenticator[] authenticators;

        private VirtualAuthenticatorManagerGetAuthenticatorsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerGetAuthenticatorsResponseParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerGetAuthenticatorsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerGetAuthenticatorsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerGetAuthenticatorsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerGetAuthenticatorsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerGetAuthenticatorsResponseParams(elementsOrVersion);
                    {
                        
                    result.authenticators = decoder0.readServiceInterfaces(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH, VirtualAuthenticator.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.authenticators, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH, VirtualAuthenticator.MANAGER);
        }
    }

    static class VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VirtualAuthenticatorManager.GetAuthenticatorsResponse mCallback;

        VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsForwardToCallback(VirtualAuthenticatorManager.GetAuthenticatorsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_AUTHENTICATORS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VirtualAuthenticatorManagerGetAuthenticatorsResponseParams response = VirtualAuthenticatorManagerGetAuthenticatorsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.authenticators);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsProxyToResponder implements VirtualAuthenticatorManager.GetAuthenticatorsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VirtualAuthenticatorManagerGetAuthenticatorsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(VirtualAuthenticator[] authenticators) {
            VirtualAuthenticatorManagerGetAuthenticatorsResponseParams _response = new VirtualAuthenticatorManagerGetAuthenticatorsResponseParams();

            _response.authenticators = authenticators;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AUTHENTICATORS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VirtualAuthenticatorManagerRemoveAuthenticatorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String id;

        private VirtualAuthenticatorManagerRemoveAuthenticatorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerRemoveAuthenticatorParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerRemoveAuthenticatorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerRemoveAuthenticatorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerRemoveAuthenticatorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerRemoveAuthenticatorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerRemoveAuthenticatorParams(elementsOrVersion);
                    {
                        
                    result.id = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.id, 8, false);
        }
    }



    
    static final class VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean removed;

        private VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams(elementsOrVersion);
                    {
                        
                    result.removed = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.removed, 8, 0);
        }
    }

    static class VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VirtualAuthenticatorManager.RemoveAuthenticatorResponse mCallback;

        VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsForwardToCallback(VirtualAuthenticatorManager.RemoveAuthenticatorResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REMOVE_AUTHENTICATOR_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams response = VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.removed);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsProxyToResponder implements VirtualAuthenticatorManager.RemoveAuthenticatorResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VirtualAuthenticatorManagerRemoveAuthenticatorResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean removed) {
            VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams _response = new VirtualAuthenticatorManagerRemoveAuthenticatorResponseParams();

            _response.removed = removed;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REMOVE_AUTHENTICATOR_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class VirtualAuthenticatorManagerClearAuthenticatorsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VirtualAuthenticatorManagerClearAuthenticatorsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerClearAuthenticatorsParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerClearAuthenticatorsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerClearAuthenticatorsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerClearAuthenticatorsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerClearAuthenticatorsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerClearAuthenticatorsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class VirtualAuthenticatorManagerClearAuthenticatorsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private VirtualAuthenticatorManagerClearAuthenticatorsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public VirtualAuthenticatorManagerClearAuthenticatorsResponseParams() {
            this(0);
        }

        public static VirtualAuthenticatorManagerClearAuthenticatorsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static VirtualAuthenticatorManagerClearAuthenticatorsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static VirtualAuthenticatorManagerClearAuthenticatorsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            VirtualAuthenticatorManagerClearAuthenticatorsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new VirtualAuthenticatorManagerClearAuthenticatorsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final VirtualAuthenticatorManager.ClearAuthenticatorsResponse mCallback;

        VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsForwardToCallback(VirtualAuthenticatorManager.ClearAuthenticatorsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_AUTHENTICATORS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsProxyToResponder implements VirtualAuthenticatorManager.ClearAuthenticatorsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        VirtualAuthenticatorManagerClearAuthenticatorsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            VirtualAuthenticatorManagerClearAuthenticatorsResponseParams _response = new VirtualAuthenticatorManagerClearAuthenticatorsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_AUTHENTICATORS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
