
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/wake_lock/wake_lock.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WakeLockService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WakeLockService, WakeLockService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WakeLockService, WakeLockService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.WakeLockService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WakeLockService impl) {
            return new Stub(core, impl);
        }

        @Override
        public WakeLockService[] buildArray(int size) {
          return new WakeLockService[size];
        }
    };


    private static final int GET_WAKE_LOCK_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WakeLockService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getWakeLock(
int type, int reason, String description, com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.device.mojom.WakeLock> wakeLock) {

            WakeLockServiceGetWakeLockParams _message = new WakeLockServiceGetWakeLockParams();

            _message.type = type;

            _message.reason = reason;

            _message.description = description;

            _message.wakeLock = wakeLock;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_WAKE_LOCK_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WakeLockService> {

        Stub(com.vccorp.mojo.system.Core core, WakeLockService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WakeLockService_Internal.MANAGER, messageWithHeader);





                    case GET_WAKE_LOCK_ORDINAL: {

                        WakeLockServiceGetWakeLockParams data =
                                WakeLockServiceGetWakeLockParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getWakeLock(data.type, data.reason, data.description, data.wakeLock);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WakeLockService_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WakeLockServiceGetWakeLockParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int type;
        public int reason;
        public String description;
        public com.vccorp.mojo.bindings.InterfaceRequest<com.vccorp.device.mojom.WakeLock> wakeLock;

        private WakeLockServiceGetWakeLockParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WakeLockServiceGetWakeLockParams() {
            this(0);
        }

        public static WakeLockServiceGetWakeLockParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WakeLockServiceGetWakeLockParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WakeLockServiceGetWakeLockParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WakeLockServiceGetWakeLockParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WakeLockServiceGetWakeLockParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readInt(8);
                        com.vccorp.device.mojom.WakeLockType.validate(result.type);
                    }
                    {
                        
                    result.reason = decoder0.readInt(12);
                        com.vccorp.device.mojom.WakeLockReason.validate(result.reason);
                    }
                    {
                        
                    result.description = decoder0.readString(16, false);
                    }
                    {
                        
                    result.wakeLock = decoder0.readInterfaceRequest(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8);
            
            encoder0.encode(this.reason, 12);
            
            encoder0.encode(this.description, 16, false);
            
            encoder0.encode(this.wakeLock, 24, false);
        }
    }



}
