
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/dom_storage/storage_area.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class StorageAreaObserver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<StorageAreaObserver, StorageAreaObserver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<StorageAreaObserver, StorageAreaObserver.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.StorageAreaObserver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, StorageAreaObserver impl) {
            return new Stub(core, impl);
        }

        @Override
        public StorageAreaObserver[] buildArray(int size) {
          return new StorageAreaObserver[size];
        }
    };


    private static final int KEY_ADDED_ORDINAL = 0;

    private static final int KEY_CHANGED_ORDINAL = 1;

    private static final int KEY_DELETED_ORDINAL = 2;

    private static final int ALL_DELETED_ORDINAL = 3;

    private static final int SHOULD_SEND_OLD_VALUE_ON_MUTATIONS_ORDINAL = 4;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements StorageAreaObserver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void keyAdded(
byte[] key, byte[] value, String source) {

            StorageAreaObserverKeyAddedParams _message = new StorageAreaObserverKeyAddedParams();

            _message.key = key;

            _message.value = value;

            _message.source = source;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(KEY_ADDED_ORDINAL)));

        }


        @Override
        public void keyChanged(
byte[] key, byte[] newValue, byte[] oldValue, String source) {

            StorageAreaObserverKeyChangedParams _message = new StorageAreaObserverKeyChangedParams();

            _message.key = key;

            _message.newValue = newValue;

            _message.oldValue = oldValue;

            _message.source = source;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(KEY_CHANGED_ORDINAL)));

        }


        @Override
        public void keyDeleted(
byte[] key, byte[] oldValue, String source) {

            StorageAreaObserverKeyDeletedParams _message = new StorageAreaObserverKeyDeletedParams();

            _message.key = key;

            _message.oldValue = oldValue;

            _message.source = source;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(KEY_DELETED_ORDINAL)));

        }


        @Override
        public void allDeleted(
String source) {

            StorageAreaObserverAllDeletedParams _message = new StorageAreaObserverAllDeletedParams();

            _message.source = source;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ALL_DELETED_ORDINAL)));

        }


        @Override
        public void shouldSendOldValueOnMutations(
boolean value) {

            StorageAreaObserverShouldSendOldValueOnMutationsParams _message = new StorageAreaObserverShouldSendOldValueOnMutationsParams();

            _message.value = value;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SHOULD_SEND_OLD_VALUE_ON_MUTATIONS_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<StorageAreaObserver> {

        Stub(com.vccorp.mojo.system.Core core, StorageAreaObserver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                StorageAreaObserver_Internal.MANAGER, messageWithHeader);





                    case KEY_ADDED_ORDINAL: {

                        StorageAreaObserverKeyAddedParams data =
                                StorageAreaObserverKeyAddedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().keyAdded(data.key, data.value, data.source);
                        return true;
                    }





                    case KEY_CHANGED_ORDINAL: {

                        StorageAreaObserverKeyChangedParams data =
                                StorageAreaObserverKeyChangedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().keyChanged(data.key, data.newValue, data.oldValue, data.source);
                        return true;
                    }





                    case KEY_DELETED_ORDINAL: {

                        StorageAreaObserverKeyDeletedParams data =
                                StorageAreaObserverKeyDeletedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().keyDeleted(data.key, data.oldValue, data.source);
                        return true;
                    }





                    case ALL_DELETED_ORDINAL: {

                        StorageAreaObserverAllDeletedParams data =
                                StorageAreaObserverAllDeletedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().allDeleted(data.source);
                        return true;
                    }





                    case SHOULD_SEND_OLD_VALUE_ON_MUTATIONS_ORDINAL: {

                        StorageAreaObserverShouldSendOldValueOnMutationsParams data =
                                StorageAreaObserverShouldSendOldValueOnMutationsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().shouldSendOldValueOnMutations(data.value);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), StorageAreaObserver_Internal.MANAGER, messageWithHeader, receiver);












                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class StorageAreaObserverKeyAddedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public byte[] key;
        public byte[] value;
        public String source;

        private StorageAreaObserverKeyAddedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public StorageAreaObserverKeyAddedParams() {
            this(0);
        }

        public static StorageAreaObserverKeyAddedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static StorageAreaObserverKeyAddedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static StorageAreaObserverKeyAddedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            StorageAreaObserverKeyAddedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new StorageAreaObserverKeyAddedParams(elementsOrVersion);
                    {
                        
                    result.key = decoder0.readBytes(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.value = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.source = decoder0.readString(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.key, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.value, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.source, 24, false);
        }
    }



    
    static final class StorageAreaObserverKeyChangedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public byte[] key;
        public byte[] newValue;
        public byte[] oldValue;
        public String source;

        private StorageAreaObserverKeyChangedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public StorageAreaObserverKeyChangedParams() {
            this(0);
        }

        public static StorageAreaObserverKeyChangedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static StorageAreaObserverKeyChangedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static StorageAreaObserverKeyChangedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            StorageAreaObserverKeyChangedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new StorageAreaObserverKeyChangedParams(elementsOrVersion);
                    {
                        
                    result.key = decoder0.readBytes(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.newValue = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.oldValue = decoder0.readBytes(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.source = decoder0.readString(32, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.key, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.newValue, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.oldValue, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.source, 32, false);
        }
    }



    
    static final class StorageAreaObserverKeyDeletedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public byte[] key;
        public byte[] oldValue;
        public String source;

        private StorageAreaObserverKeyDeletedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public StorageAreaObserverKeyDeletedParams() {
            this(0);
        }

        public static StorageAreaObserverKeyDeletedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static StorageAreaObserverKeyDeletedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static StorageAreaObserverKeyDeletedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            StorageAreaObserverKeyDeletedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new StorageAreaObserverKeyDeletedParams(elementsOrVersion);
                    {
                        
                    result.key = decoder0.readBytes(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.oldValue = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    result.source = decoder0.readString(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.key, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.oldValue, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.source, 24, false);
        }
    }



    
    static final class StorageAreaObserverAllDeletedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String source;

        private StorageAreaObserverAllDeletedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public StorageAreaObserverAllDeletedParams() {
            this(0);
        }

        public static StorageAreaObserverAllDeletedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static StorageAreaObserverAllDeletedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static StorageAreaObserverAllDeletedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            StorageAreaObserverAllDeletedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new StorageAreaObserverAllDeletedParams(elementsOrVersion);
                    {
                        
                    result.source = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.source, 8, false);
        }
    }



    
    static final class StorageAreaObserverShouldSendOldValueOnMutationsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean value;

        private StorageAreaObserverShouldSendOldValueOnMutationsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public StorageAreaObserverShouldSendOldValueOnMutationsParams() {
            this(0);
        }

        public static StorageAreaObserverShouldSendOldValueOnMutationsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static StorageAreaObserverShouldSendOldValueOnMutationsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static StorageAreaObserverShouldSendOldValueOnMutationsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            StorageAreaObserverShouldSendOldValueOnMutationsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new StorageAreaObserverShouldSendOldValueOnMutationsParams(elementsOrVersion);
                    {
                        
                    result.value = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.value, 8, 0);
        }
    }



}
