
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class SessionStorageNamespace_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<SessionStorageNamespace, SessionStorageNamespace.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<SessionStorageNamespace, SessionStorageNamespace.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.SessionStorageNamespace";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, SessionStorageNamespace impl) {
            return new Stub(core, impl);
        }

        @Override
        public SessionStorageNamespace[] buildArray(int size) {
          return new SessionStorageNamespace[size];
        }
    };


    private static final int OPEN_AREA_ORDINAL = 0;

    private static final int CLONE_ORDINAL = 1;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements SessionStorageNamespace.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void openArea(
com.vccorp.url.mojom.Origin origin, com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported area) {

            SessionStorageNamespaceOpenAreaParams _message = new SessionStorageNamespaceOpenAreaParams();

            _message.origin = origin;

            _message.area = area;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(OPEN_AREA_ORDINAL)));

        }


        @Override
        public void clone(
String cloneToNamespace) {

            SessionStorageNamespaceCloneParams _message = new SessionStorageNamespaceCloneParams();

            _message.cloneToNamespace = cloneToNamespace;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLONE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<SessionStorageNamespace> {

        Stub(com.vccorp.mojo.system.Core core, SessionStorageNamespace impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                SessionStorageNamespace_Internal.MANAGER, messageWithHeader);





                    case OPEN_AREA_ORDINAL: {

                        SessionStorageNamespaceOpenAreaParams data =
                                SessionStorageNamespaceOpenAreaParams.deserialize(messageWithHeader.getPayload());

                        getImpl().openArea(data.origin, data.area);
                        return true;
                    }





                    case CLONE_ORDINAL: {

                        SessionStorageNamespaceCloneParams data =
                                SessionStorageNamespaceCloneParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clone(data.cloneToNamespace);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), SessionStorageNamespace_Internal.MANAGER, messageWithHeader, receiver);






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class SessionStorageNamespaceOpenAreaParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported area;

        private SessionStorageNamespaceOpenAreaParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public SessionStorageNamespaceOpenAreaParams() {
            this(0);
        }

        public static SessionStorageNamespaceOpenAreaParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static SessionStorageNamespaceOpenAreaParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static SessionStorageNamespaceOpenAreaParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            SessionStorageNamespaceOpenAreaParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new SessionStorageNamespaceOpenAreaParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.area = decoder0.readAssociatedInterfaceRequestNotSupported(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.area, 16, false);
        }
    }



    
    static final class SessionStorageNamespaceCloneParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String cloneToNamespace;

        private SessionStorageNamespaceCloneParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public SessionStorageNamespaceCloneParams() {
            this(0);
        }

        public static SessionStorageNamespaceCloneParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static SessionStorageNamespaceCloneParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static SessionStorageNamespaceCloneParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            SessionStorageNamespaceCloneParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new SessionStorageNamespaceCloneParams(elementsOrVersion);
                    {
                        
                    result.cloneToNamespace = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cloneToNamespace, 8, false);
        }
    }



}
