
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/service_worker/service_worker_registration.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class ServiceWorkerRegistrationObject_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerRegistrationObject, ServiceWorkerRegistrationObject.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<ServiceWorkerRegistrationObject, ServiceWorkerRegistrationObject.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.ServiceWorkerRegistrationObject";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, ServiceWorkerRegistrationObject impl) {
            return new Stub(core, impl);
        }

        @Override
        public ServiceWorkerRegistrationObject[] buildArray(int size) {
          return new ServiceWorkerRegistrationObject[size];
        }
    };


    private static final int SET_SERVICE_WORKER_OBJECTS_ORDINAL = 0;

    private static final int SET_UPDATE_VIA_CACHE_ORDINAL = 1;

    private static final int UPDATE_FOUND_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements ServiceWorkerRegistrationObject.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setServiceWorkerObjects(
ChangedServiceWorkerObjectsMask changedMask, ServiceWorkerObjectInfo installing, ServiceWorkerObjectInfo waiting, ServiceWorkerObjectInfo active) {

            ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams _message = new ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams();

            _message.changedMask = changedMask;

            _message.installing = installing;

            _message.waiting = waiting;

            _message.active = active;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_SERVICE_WORKER_OBJECTS_ORDINAL)));

        }


        @Override
        public void setUpdateViaCache(
int updateViaCache) {

            ServiceWorkerRegistrationObjectSetUpdateViaCacheParams _message = new ServiceWorkerRegistrationObjectSetUpdateViaCacheParams();

            _message.updateViaCache = updateViaCache;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_UPDATE_VIA_CACHE_ORDINAL)));

        }


        @Override
        public void updateFound(
) {

            ServiceWorkerRegistrationObjectUpdateFoundParams _message = new ServiceWorkerRegistrationObjectUpdateFoundParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(UPDATE_FOUND_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<ServiceWorkerRegistrationObject> {

        Stub(com.vccorp.mojo.system.Core core, ServiceWorkerRegistrationObject impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServiceWorkerRegistrationObject_Internal.MANAGER, messageWithHeader);





                    case SET_SERVICE_WORKER_OBJECTS_ORDINAL: {

                        ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams data =
                                ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setServiceWorkerObjects(data.changedMask, data.installing, data.waiting, data.active);
                        return true;
                    }





                    case SET_UPDATE_VIA_CACHE_ORDINAL: {

                        ServiceWorkerRegistrationObjectSetUpdateViaCacheParams data =
                                ServiceWorkerRegistrationObjectSetUpdateViaCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setUpdateViaCache(data.updateViaCache);
                        return true;
                    }





                    case UPDATE_FOUND_ORDINAL: {

                        ServiceWorkerRegistrationObjectUpdateFoundParams.deserialize(messageWithHeader.getPayload());

                        getImpl().updateFound();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServiceWorkerRegistrationObject_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ChangedServiceWorkerObjectsMask changedMask;
        public ServiceWorkerObjectInfo installing;
        public ServiceWorkerObjectInfo waiting;
        public ServiceWorkerObjectInfo active;

        private ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectSetServiceWorkerObjectsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.changedMask = ChangedServiceWorkerObjectsMask.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.installing = ServiceWorkerObjectInfo.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.waiting = ServiceWorkerObjectInfo.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                    result.active = ServiceWorkerObjectInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.changedMask, 8, false);
            
            encoder0.encode(this.installing, 16, true);
            
            encoder0.encode(this.waiting, 24, true);
            
            encoder0.encode(this.active, 32, true);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectSetUpdateViaCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int updateViaCache;

        private ServiceWorkerRegistrationObjectSetUpdateViaCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectSetUpdateViaCacheParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectSetUpdateViaCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectSetUpdateViaCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectSetUpdateViaCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectSetUpdateViaCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectSetUpdateViaCacheParams(elementsOrVersion);
                    {
                        
                    result.updateViaCache = decoder0.readInt(8);
                        ServiceWorkerUpdateViaCache.validate(result.updateViaCache);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.updateViaCache, 8);
        }
    }



    
    static final class ServiceWorkerRegistrationObjectUpdateFoundParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private ServiceWorkerRegistrationObjectUpdateFoundParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public ServiceWorkerRegistrationObjectUpdateFoundParams() {
            this(0);
        }

        public static ServiceWorkerRegistrationObjectUpdateFoundParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static ServiceWorkerRegistrationObjectUpdateFoundParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static ServiceWorkerRegistrationObjectUpdateFoundParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            ServiceWorkerRegistrationObjectUpdateFoundParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new ServiceWorkerRegistrationObjectUpdateFoundParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
