
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/fetch/fetch_api_request.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class RequestContextType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int UNSPECIFIED = 0;
    public static final int AUDIO = 1; // UNSPECIFIED + 1
    public static final int BEACON = 2; // AUDIO + 1
    public static final int CSP_REPORT = 3; // BEACON + 1
    public static final int DOWNLOAD = 4; // CSP_REPORT + 1
    public static final int EMBED = 5; // DOWNLOAD + 1
    public static final int EVENT_SOURCE = 6; // EMBED + 1
    public static final int FAVICON = 7; // EVENT_SOURCE + 1
    public static final int FETCH = 8; // FAVICON + 1
    public static final int FONT = 9; // FETCH + 1
    public static final int FORM = 10; // FONT + 1
    public static final int FRAME = 11; // FORM + 1
    public static final int HYPERLINK = 12; // FRAME + 1
    public static final int IFRAME = 13; // HYPERLINK + 1
    public static final int IMAGE = 14; // IFRAME + 1
    public static final int IMAGE_SET = 15; // IMAGE + 1
    public static final int IMPORT = 16; // IMAGE_SET + 1
    public static final int INTERNAL = 17; // IMPORT + 1
    public static final int LOCATION = 18; // INTERNAL + 1
    public static final int MANIFEST = 19; // LOCATION + 1
    public static final int OBJECT = 20; // MANIFEST + 1
    public static final int PING = 21; // OBJECT + 1
    public static final int PLUGIN = 22; // PING + 1
    public static final int PREFETCH = 23; // PLUGIN + 1
    public static final int SCRIPT = 24; // PREFETCH + 1
    public static final int SERVICE_WORKER = 25; // SCRIPT + 1
    public static final int SHARED_WORKER = 26; // SERVICE_WORKER + 1
    public static final int SUBRESOURCE = 27; // SHARED_WORKER + 1
    public static final int STYLE = 28; // SUBRESOURCE + 1
    public static final int TRACK = 29; // STYLE + 1
    public static final int VIDEO = 30; // TRACK + 1
    public static final int WORKER = 31; // VIDEO + 1
    public static final int XML_HTTP_REQUEST = 32; // WORKER + 1
    public static final int XSLT = 33; // XML_HTTP_REQUEST + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 33;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private RequestContextType() {}
}