
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/renderer_preferences.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class RendererPreferences extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(88, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean canAcceptLoadDrops;
    public boolean shouldAntialiasText;
    public int hinting;
    public boolean useAutohinter;
    public boolean useBitmaps;
    public int subpixelRendering;
    public boolean useSubpixelPositioning;
    public int focusRingColor;
    public float minimumStrokeWidthForFocusRing;
    public boolean isFocusRingOutset;
    public int activeSelectionBgColor;
    public int activeSelectionFgColor;
    public int inactiveSelectionBgColor;
    public int inactiveSelectionFgColor;
    public boolean browserHandlesAllTopLevelRequests;
    public com.vccorp.mojo_base.mojom.TimeDelta caretBlinkInterval;
    public boolean useCustomColors;
    public boolean enableReferrers;
    public boolean enableDoNotTrack;
    public boolean enableEncryptedMedia;
    public String webrtcIpHandlingPolicy;
    public short webrtcUdpMinPort;
    public short webrtcUdpMaxPort;
    public String userAgentOverride;
    public String acceptLanguages;
    public boolean disableClientBlockedErrorPage;
    public boolean pluginFullscreenAllowed;
    public String networkContryIso;

    private RendererPreferences(int version) {
        super(STRUCT_SIZE, version);
        this.canAcceptLoadDrops = (boolean) true;
        this.shouldAntialiasText = (boolean) true;
        this.hinting = (int) com.vccorp.gfx.mojom.Hinting.MEDIUM;
        this.useAutohinter = (boolean) false;
        this.useBitmaps = (boolean) false;
        this.subpixelRendering = (int) com.vccorp.gfx.mojom.SubpixelRendering.NONE;
        this.useSubpixelPositioning = (boolean) false;
        this.focusRingColor = (int) 4293236480L;
        this.minimumStrokeWidthForFocusRing = (float) 1.0;
        this.isFocusRingOutset = (boolean) false;
        this.activeSelectionBgColor = (int) 4280193279L;
        this.activeSelectionFgColor = (int) 4294967295L;
        this.inactiveSelectionBgColor = (int) 4291348680L;
        this.inactiveSelectionFgColor = (int) 4281479730L;
        this.browserHandlesAllTopLevelRequests = (boolean) false;
        this.useCustomColors = (boolean) true;
        this.enableReferrers = (boolean) true;
        this.enableDoNotTrack = (boolean) false;
        this.enableEncryptedMedia = (boolean) true;
        this.webrtcUdpMinPort = (short) 0;
        this.webrtcUdpMaxPort = (short) 0;
        this.disableClientBlockedErrorPage = (boolean) false;
        this.pluginFullscreenAllowed = (boolean) true;
    }

    public RendererPreferences() {
        this(0);
    }

    public static RendererPreferences deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static RendererPreferences deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static RendererPreferences decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        RendererPreferences result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new RendererPreferences(elementsOrVersion);
                {
                    
                result.canAcceptLoadDrops = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.shouldAntialiasText = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.useAutohinter = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.useBitmaps = decoder0.readBoolean(8, 3);
                }
                {
                    
                result.useSubpixelPositioning = decoder0.readBoolean(8, 4);
                }
                {
                    
                result.isFocusRingOutset = decoder0.readBoolean(8, 5);
                }
                {
                    
                result.browserHandlesAllTopLevelRequests = decoder0.readBoolean(8, 6);
                }
                {
                    
                result.useCustomColors = decoder0.readBoolean(8, 7);
                }
                {
                    
                result.enableReferrers = decoder0.readBoolean(9, 0);
                }
                {
                    
                result.enableDoNotTrack = decoder0.readBoolean(9, 1);
                }
                {
                    
                result.enableEncryptedMedia = decoder0.readBoolean(9, 2);
                }
                {
                    
                result.disableClientBlockedErrorPage = decoder0.readBoolean(9, 3);
                }
                {
                    
                result.pluginFullscreenAllowed = decoder0.readBoolean(9, 4);
                }
                {
                    
                result.webrtcUdpMinPort = decoder0.readShort(10);
                }
                {
                    
                result.hinting = decoder0.readInt(12);
                    com.vccorp.gfx.mojom.Hinting.validate(result.hinting);
                }
                {
                    
                result.subpixelRendering = decoder0.readInt(16);
                    com.vccorp.gfx.mojom.SubpixelRendering.validate(result.subpixelRendering);
                }
                {
                    
                result.focusRingColor = decoder0.readInt(20);
                }
                {
                    
                result.minimumStrokeWidthForFocusRing = decoder0.readFloat(24);
                }
                {
                    
                result.activeSelectionBgColor = decoder0.readInt(28);
                }
                {
                    
                result.activeSelectionFgColor = decoder0.readInt(32);
                }
                {
                    
                result.inactiveSelectionBgColor = decoder0.readInt(36);
                }
                {
                    
                result.inactiveSelectionFgColor = decoder0.readInt(40);
                }
                {
                    
                result.webrtcUdpMaxPort = decoder0.readShort(44);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, true);
                result.caretBlinkInterval = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }
                {
                    
                result.webrtcIpHandlingPolicy = decoder0.readString(56, false);
                }
                {
                    
                result.userAgentOverride = decoder0.readString(64, false);
                }
                {
                    
                result.acceptLanguages = decoder0.readString(72, false);
                }
                {
                    
                result.networkContryIso = decoder0.readString(80, false);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.canAcceptLoadDrops, 8, 0);
        
        encoder0.encode(this.shouldAntialiasText, 8, 1);
        
        encoder0.encode(this.useAutohinter, 8, 2);
        
        encoder0.encode(this.useBitmaps, 8, 3);
        
        encoder0.encode(this.useSubpixelPositioning, 8, 4);
        
        encoder0.encode(this.isFocusRingOutset, 8, 5);
        
        encoder0.encode(this.browserHandlesAllTopLevelRequests, 8, 6);
        
        encoder0.encode(this.useCustomColors, 8, 7);
        
        encoder0.encode(this.enableReferrers, 9, 0);
        
        encoder0.encode(this.enableDoNotTrack, 9, 1);
        
        encoder0.encode(this.enableEncryptedMedia, 9, 2);
        
        encoder0.encode(this.disableClientBlockedErrorPage, 9, 3);
        
        encoder0.encode(this.pluginFullscreenAllowed, 9, 4);
        
        encoder0.encode(this.webrtcUdpMinPort, 10);
        
        encoder0.encode(this.hinting, 12);
        
        encoder0.encode(this.subpixelRendering, 16);
        
        encoder0.encode(this.focusRingColor, 20);
        
        encoder0.encode(this.minimumStrokeWidthForFocusRing, 24);
        
        encoder0.encode(this.activeSelectionBgColor, 28);
        
        encoder0.encode(this.activeSelectionFgColor, 32);
        
        encoder0.encode(this.inactiveSelectionBgColor, 36);
        
        encoder0.encode(this.inactiveSelectionFgColor, 40);
        
        encoder0.encode(this.webrtcUdpMaxPort, 44);
        
        encoder0.encode(this.caretBlinkInterval, 48, true);
        
        encoder0.encode(this.webrtcIpHandlingPolicy, 56, false);
        
        encoder0.encode(this.userAgentOverride, 64, false);
        
        encoder0.encode(this.acceptLanguages, 72, false);
        
        encoder0.encode(this.networkContryIso, 80, false);
    }
}