
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/loader/previews_resource_loading_hints.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PreviewsResourceLoadingHintsReceiver_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PreviewsResourceLoadingHintsReceiver, PreviewsResourceLoadingHintsReceiver.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PreviewsResourceLoadingHintsReceiver, PreviewsResourceLoadingHintsReceiver.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.PreviewsResourceLoadingHintsReceiver";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PreviewsResourceLoadingHintsReceiver impl) {
            return new Stub(core, impl);
        }

        @Override
        public PreviewsResourceLoadingHintsReceiver[] buildArray(int size) {
          return new PreviewsResourceLoadingHintsReceiver[size];
        }
    };


    private static final int SET_RESOURCE_LOADING_HINTS_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PreviewsResourceLoadingHintsReceiver.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setResourceLoadingHints(
PreviewsResourceLoadingHints previewsResourceLoadingHints) {

            PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams _message = new PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams();

            _message.previewsResourceLoadingHints = previewsResourceLoadingHints;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_RESOURCE_LOADING_HINTS_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PreviewsResourceLoadingHintsReceiver> {

        Stub(com.vccorp.mojo.system.Core core, PreviewsResourceLoadingHintsReceiver impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PreviewsResourceLoadingHintsReceiver_Internal.MANAGER, messageWithHeader);





                    case SET_RESOURCE_LOADING_HINTS_ORDINAL: {

                        PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams data =
                                PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setResourceLoadingHints(data.previewsResourceLoadingHints);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PreviewsResourceLoadingHintsReceiver_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PreviewsResourceLoadingHints previewsResourceLoadingHints;

        private PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams() {
            this(0);
        }

        public static PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PreviewsResourceLoadingHintsReceiverSetResourceLoadingHintsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.previewsResourceLoadingHints = PreviewsResourceLoadingHints.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.previewsResourceLoadingHints, 8, false);
        }
    }



}
